/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.operator.learner.associations.FrequentItemSet;
import com.rapidminer.operator.learner.associations.FrequentItemSets;
import com.rapidminer.operator.learner.associations.Item;
import com.rapidminer.tools.Tools;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.table.AbstractTableModel;

public class FrequentItemSetsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1497336028647445690L;
    private static final int COLUMN_SIZE = 0;
    private static final int COLUMN_SUPPORT = 1;
    private FrequentItemSets frequentSets;
    private int[] mapping = null;
    private int maxItemSetSize = 0;

    public FrequentItemSetsTableModel(FrequentItemSets frequentSets) {
        this.frequentSets = frequentSets;
        this.updateFilter(0, Integer.MAX_VALUE, null);
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Size";
        }
        if (column == 1) {
            return "Support";
        }
        return "Item " + (column - 1);
    }

    public int getColumnCount() {
        return this.maxItemSetSize + 2;
    }

    public int getRowCount() {
        return this.mapping.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        FrequentItemSet itemSet = this.frequentSets.getItemSet(this.mapping[rowIndex]);
        if (columnIndex == 0) {
            return itemSet.getItems().size();
        }
        if (columnIndex == 1) {
            return Tools.formatNumber((double)itemSet.getFrequency() / (double)this.frequentSets.getNumberOfTransactions());
        }
        int actualIndex = columnIndex - 2;
        if (actualIndex < itemSet.getNumberOfItems()) {
            return itemSet.getItem(actualIndex).toString();
        }
        return "";
    }

    public void updateFilter(int min, int max, String itemName) {
        LinkedList<Integer> indices = new LinkedList<Integer>();
        int index = 0;
        this.maxItemSetSize = 0;
        String[] itemNames = null;
        if (itemName != null) {
            itemNames = itemName.split(",");
        }
        for (FrequentItemSet itemSet : this.frequentSets) {
            if (this.acceptItemSet(itemSet, min, max, itemNames)) {
                indices.add(index);
                this.maxItemSetSize = Math.max(this.maxItemSetSize, itemSet.getNumberOfItems());
            }
            ++index;
        }
        this.mapping = new int[indices.size()];
        int counter = 0;
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int c = (Integer)iterator.next();
            this.mapping[counter++] = c;
        }
        this.fireTableStructureChanged();
    }

    private boolean acceptItemSet(FrequentItemSet itemSet, int min, int max, String[] itemNames) {
        int size = itemSet.getNumberOfItems();
        if (size < min) {
            return false;
        }
        if (size > max) {
            return false;
        }
        if (itemNames == null || itemNames.length == 0) {
            return true;
        }
        for (Item item : itemSet.getItems()) {
            String[] stringArray = itemNames;
            int n = itemNames.length;
            int n2 = 0;
            while (n2 < n) {
                String itemName = stringArray[n2];
                if (item.toString().indexOf(itemName.trim()) >= 0) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

