/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.gui.plotter.ColorProvider;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.report.Renderable;
import com.rapidminer.tools.math.ROCData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROCChartPlotter
extends JPanel
implements Renderable {
    private static final long serialVersionUID = -5819082000307077237L;
    private static final int NUMBER_OF_POINTS = 500;
    private YIntervalSeriesCollection dataset = null;
    private final Map<String, List<ROCData>> rocDataLists = new HashMap<String, List<ROCData>>();
    private final ColorProvider colorProvider = new ColorProvider();

    public ROCChartPlotter() {
        this.setBackground(Color.white);
    }

    public void addROCData(String name, ROCData singleROCData) {
        LinkedList<ROCData> tempList = new LinkedList<ROCData>();
        tempList.add(singleROCData);
        this.addROCData(name, tempList);
    }

    public void addROCData(String name, List<ROCData> averageROCData) {
        this.rocDataLists.put(name, averageROCData);
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        ValueAxis valueAxis = plot.getRangeAxis();
        valueAxis.setLabelFont(PlotterAdapter.LABEL_FONT_BOLD);
        valueAxis.setTickLabelFont(PlotterAdapter.LABEL_FONT);
        ValueAxis domainAxis = plot.getDomainAxis();
        domainAxis.setLabelFont(PlotterAdapter.LABEL_FONT_BOLD);
        domainAxis.setTickLabelFont(PlotterAdapter.LABEL_FONT);
        DeviationRenderer renderer = new DeviationRenderer(true, false);
        BasicStroke stroke = new BasicStroke(2.0f, 1, 1);
        if (dataset.getSeriesCount() == 1) {
            renderer.setSeriesStroke(0, (Stroke)stroke);
            renderer.setSeriesPaint(0, (Paint)Color.RED);
            renderer.setSeriesFillPaint(0, (Paint)Color.RED);
        } else if (dataset.getSeriesCount() == 2) {
            renderer.setSeriesStroke(0, (Stroke)stroke);
            renderer.setSeriesPaint(0, (Paint)Color.RED);
            renderer.setSeriesFillPaint(0, (Paint)Color.RED);
            renderer.setSeriesStroke(1, (Stroke)stroke);
            renderer.setSeriesPaint(1, (Paint)Color.BLUE);
            renderer.setSeriesFillPaint(1, (Paint)Color.BLUE);
        } else {
            int i = 0;
            while (i < dataset.getSeriesCount()) {
                renderer.setSeriesStroke(i, (Stroke)stroke);
                Color color = this.colorProvider.getPointColor((double)i / (double)(dataset.getSeriesCount() - 1));
                renderer.setSeriesPaint(i, (Paint)color);
                renderer.setSeriesFillPaint(i, (Paint)color);
                ++i;
            }
        }
        renderer.setAlpha(0.12f);
        plot.setRenderer((XYItemRenderer)renderer);
        LegendTitle legend = chart.getLegend();
        if (legend != null) {
            legend.setPosition(RectangleEdge.TOP);
            legend.setFrame((BlockFrame)BlockBorder.NONE);
            legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
            legend.setItemFont(PlotterAdapter.LABEL_FONT);
        }
        return chart;
    }

    private void prepareData() {
        this.dataset = new YIntervalSeriesCollection();
        Iterator<Map.Entry<String, List<ROCData>>> r = this.rocDataLists.entrySet().iterator();
        boolean showThresholds = true;
        if (this.rocDataLists.size() > 1) {
            showThresholds = false;
        }
        while (r.hasNext()) {
            Map.Entry<String, List<ROCData>> entry = r.next();
            YIntervalSeries rocSeries = new YIntervalSeries((Comparable)((Object)entry.getKey()));
            YIntervalSeries thresholdSeries = new YIntervalSeries((Comparable)((Object)(String.valueOf(entry.getKey()) + " (Thresholds)")));
            List<ROCData> dataList = entry.getValue();
            int i = 0;
            while (i <= 500) {
                double rocSum = 0.0;
                double rocSquaredSum = 0.0;
                double thresholdSum = 0.0;
                double thresholdSquaredSum = 0.0;
                for (ROCData data : dataList) {
                    double rocValue = data.getInterpolatedTruePositives((double)i / 500.0) / data.getTotalPositives();
                    rocSum += rocValue;
                    rocSquaredSum += rocValue * rocValue;
                    double thresholdValue = data.getInterpolatedThreshold((double)i / 500.0);
                    thresholdSum += thresholdValue;
                    thresholdSquaredSum += thresholdValue * thresholdValue;
                }
                double rocMean = rocSum / (double)dataList.size();
                double rocDeviation = Math.sqrt(rocSquaredSum / (double)dataList.size() - rocMean * rocMean);
                rocSeries.add((double)i / 500.0, rocMean, rocMean - rocDeviation, rocMean + rocDeviation);
                double thresholdMean = thresholdSum / (double)dataList.size();
                double thresholdDeviation = Math.sqrt(thresholdSquaredSum / (double)dataList.size() - thresholdMean * thresholdMean);
                thresholdSeries.add((double)i / 500.0, thresholdMean, thresholdMean - thresholdDeviation, thresholdMean + thresholdDeviation);
                ++i;
            }
            this.dataset.addSeries(rocSeries);
            if (!showThresholds) continue;
            this.dataset.addSeries(thresholdSeries);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintDeviationChart(g, this.getWidth(), this.getHeight());
    }

    public void paintDeviationChart(Graphics graphics, int width, int height) {
        this.prepareData();
        JFreeChart chart = this.createChart((XYDataset)this.dataset);
        chart.setBackgroundPaint((Paint)Color.white);
        LegendTitle legend = chart.getLegend();
        if (legend != null) {
            legend.setPosition(RectangleEdge.TOP);
            legend.setFrame((BlockFrame)BlockBorder.NONE);
            legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
        }
        Rectangle2D.Double drawRect = new Rectangle2D.Double(0.0, 0.0, width, height);
        chart.draw((Graphics2D)graphics, (Rectangle2D)drawRect);
    }

    @Override
    public void prepareRendering() {
    }

    @Override
    public void finishRendering() {
    }

    @Override
    public int getRenderHeight(int preferredHeight) {
        int height = this.getHeight();
        if (height < 1) {
            height = preferredHeight;
        }
        return height;
    }

    @Override
    public int getRenderWidth(int preferredWidth) {
        int width = this.getWidth();
        if (width < 1) {
            width = preferredWidth;
        }
        return width;
    }

    @Override
    public void render(Graphics graphics, int width, int height) {
        this.setSize(width, height);
        this.paintDeviationChart(graphics, width, height);
    }
}

