/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.wizards;

import com.rapidminer.gui.wizards.AbstractConfigurationWizardCreator;
import com.rapidminer.gui.wizards.ConfigurationListener;
import com.rapidminer.gui.wizards.DBExampleSourceConfigurationWizard;
import com.rapidminer.tools.Tools;

public class DBExampleSourceConfigurationWizardCreator
extends AbstractConfigurationWizardCreator {
    private static final long serialVersionUID = -3326459655851921317L;
    public static final String PARAMETER_SHOW_DATABASE_DRIVERS = "show_database_drivers";
    public static final String PARAMETER_ONLY_TABLE_NAMES = "only_table_name";
    public static final String PARAMETER_SHOW_DATABASE_CONFIGURATION = "show_database_configuration";
    public static final String PARAMETER_SYSTEM = "system";
    public static final String PARAMETER_SERVER = "server";
    public static final String PARAMETER_DB_NAME = "db_name";

    public String getButtonText() {
        return "Start Data Loading Wizard...";
    }

    public void createConfigurationWizard(ConfigurationListener listener) {
        boolean showDrivers = true;
        boolean showOnlyTableNames = false;
        boolean showDatabaseConfiguration = true;
        String system = null;
        String server = null;
        String dbName = null;
        if (this.getParameters() != null) {
            showDrivers = Tools.booleanValue(this.getParameters().get(PARAMETER_SHOW_DATABASE_DRIVERS), true);
            showOnlyTableNames = Tools.booleanValue(this.getParameters().get(PARAMETER_ONLY_TABLE_NAMES), false);
            showDatabaseConfiguration = Tools.booleanValue(this.getParameters().get(PARAMETER_SHOW_DATABASE_CONFIGURATION), true);
            if (!showDatabaseConfiguration) {
                String dbNameObject;
                String serverObject;
                String systemObject = this.getParameters().get(PARAMETER_SYSTEM);
                if (systemObject != null) {
                    system = systemObject.toString();
                }
                if ((serverObject = this.getParameters().get(PARAMETER_SERVER)) != null) {
                    server = serverObject.toString();
                }
                if ((dbNameObject = this.getParameters().get(PARAMETER_DB_NAME)) != null) {
                    dbName = dbNameObject.toString();
                }
            }
        }
        new DBExampleSourceConfigurationWizard(listener, showDrivers, showOnlyTableNames, showDatabaseConfiguration, system, server, dbName).setVisible(true);
    }
}

