/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.TextType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileEchoOperator
extends Operator {
    public static final String PARAMETER_FILE = "file";
    public static final String PARAMETER_TEXT = "text";

    public FileEchoOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        File file = this.getParameterAsFile(PARAMETER_FILE, true);
        String text = this.getParameterAsString(PARAMETER_TEXT);
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.getEncoding()));
                out.println(text);
            }
            catch (IOException e) {
                throw new UserError((Operator)this, 303, file.getName(), e);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return new IOObject[0];
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_FILE, "The file into which this operator should write the specified text.", "out", false));
        types.add(new ParameterTypeText(PARAMETER_TEXT, "The text which should be written into the file.", TextType.PLAIN, false));
        return types;
    }
}

