/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.DefaultIODescription;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IODescription;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IllegalInputException;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOConsumeOperator
extends Operator {
    public static final String PARAMETER_IO_OBJECT = "io_object";
    public static final String PARAMETER_DELETION_TYPE = "deletion_type";
    public static final String PARAMETER_DELETE_WHICH = "delete_which";
    public static final String PARAMETER_EXCEPT = "except";
    private static final String[] DELETION_TYPES = new String[]{"delete_one", "delete_all", "delete_all_but", "delete_all_but_number"};
    public static final int DELETE_ONE = 0;
    public static final int DELETE_ALL = 1;
    public static final int DELETE_ALL_BUT = 2;
    public static final int DELETE_ALL_BUT_NUMBER = 3;
    private String[] objectArray = null;

    public IOConsumeOperator(OperatorDescription description) {
        super(description);
    }

    private Class<IOObject> getSelectedClass() throws UndefinedParameterError {
        int ioType = this.getParameterAsInt(PARAMETER_IO_OBJECT);
        if (this.objectArray != null) {
            return OperatorService.getIOObjectClass(this.objectArray[ioType]);
        }
        return null;
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        Class<IOObject> clazz = this.getSelectedClass();
        if (clazz != null) {
            switch (this.getParameterAsInt(PARAMETER_DELETION_TYPE)) {
                case 0: {
                    int number = this.getParameterAsInt(PARAMETER_DELETE_WHICH);
                    this.getInput(clazz, number - 1);
                    this.log("Deleted " + number + ". " + clazz.getName() + ".");
                    break;
                }
                case 1: {
                    int counter = 0;
                    try {
                        while (true) {
                            this.getInput(clazz);
                            ++counter;
                        }
                    }
                    catch (MissingIOObjectException e) {
                        this.log("Deleted " + counter + " " + clazz.getName() + ".");
                        break;
                    }
                }
                case 2: {
                    int counter = 0;
                    IOContainer input = this.getInput();
                    int i = input.size() - 1;
                    while (i >= 0) {
                        IOObject current = input.getElementAt(i);
                        if (!clazz.isAssignableFrom(current.getClass())) {
                            input.removeElementAt(i);
                            ++counter;
                        }
                        --i;
                    }
                    this.log("Deleted " + counter + " input objects.");
                    break;
                }
                case 3: {
                    int counter = 0;
                    IOContainer input = this.getInput();
                    int number = this.getParameterAsInt(PARAMETER_EXCEPT);
                    IOObject temp = this.getInput(clazz, number - 1);
                    while (input.contains(clazz)) {
                        input.remove(clazz);
                        ++counter;
                    }
                    this.setInput(input.prepend(temp));
                    this.log("Deleted " + counter + " " + clazz.getName() + ".");
                }
            }
        }
        return new IOObject[0];
    }

    @Override
    public Class<?>[] getInputClasses() {
        Class<IOObject> clazz = null;
        try {
            clazz = this.getSelectedClass();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        if (clazz != null) {
            return new Class[]{clazz};
        }
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    protected IODescription getIODescription() {
        Class[] inputClasses = this.getInputClasses();
        boolean removeAll = true;
        try {
            removeAll = this.getParameterAsInt(PARAMETER_DELETION_TYPE) == 1;
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        if (inputClasses != null && inputClasses.length > 0) {
            return new ConsumerIODescription(inputClasses, inputClasses[0], removeAll);
        }
        return super.getIODescription();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        Set<String> ioObjects = OperatorService.getIOObjectsNames();
        this.objectArray = new String[ioObjects.size()];
        Iterator<String> i = ioObjects.iterator();
        int index = 0;
        while (i.hasNext()) {
            this.objectArray[index++] = i.next();
        }
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_IO_OBJECT, "The class of the object(s) which should be removed.", this.objectArray, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_DELETION_TYPE, "Defines the type of deletion.", DELETION_TYPES, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_DELETE_WHICH, "Defines which input object should be deleted (only used for deletion type 'delete_one').", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_EXCEPT, "Defines which input object should not be deleted (only used for deletion type 'delete_one_but_number').", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConsumerIODescription
    extends DefaultIODescription {
        private boolean removeAll = true;
        private Class<?> toRemove;

        public ConsumerIODescription(Class[] input, Class<?> toRemove, boolean removeAll) {
            super(input, new Class[0]);
            this.toRemove = toRemove;
            this.removeAll = removeAll;
        }

        @Override
        public Class<?>[] getOutputClasses(Class<?>[] input, Operator operator) throws IllegalInputException {
            LinkedList outputList = new LinkedList();
            boolean removed = false;
            int i = 0;
            while (i < input.length) {
                if (this.toRemove.isAssignableFrom(input[i])) {
                    if (this.removeAll || !removed) {
                        removed = true;
                    } else {
                        outputList.add(input[i]);
                    }
                } else {
                    outputList.add(input[i]);
                }
                ++i;
            }
            Class[] outputArray = new Class[outputList.size()];
            outputList.toArray(outputArray);
            return outputArray;
        }
    }
}

