/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.operator.clustering.HierarchicalClusterNode;
import com.rapidminer.operator.clustering.clusterer.Agglomeration;
import com.rapidminer.operator.clustering.clusterer.DistanceMatrix;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinkageMethod {
    private DistanceMatrix matrix;
    private boolean[] isDeletedData;
    private int[] clusterIds;

    public AbstractLinkageMethod(DistanceMatrix matrix, int[] clusterIds) {
        this.matrix = matrix;
        this.clusterIds = clusterIds;
        this.isDeletedData = new boolean[matrix.getHeight()];
    }

    public Agglomeration getNextAgglomeration(int nextClusterId, Map<Integer, HierarchicalClusterNode> clusterMap) {
        double minimalDistance = Double.POSITIVE_INFINITY;
        int minimalX = -1;
        int minimalY = -1;
        int x = 0;
        while (x < this.matrix.getWidth()) {
            if (!this.isDeletedData[x]) {
                int y = x + 1;
                while (y < this.matrix.getHeight()) {
                    double value;
                    if (!this.isDeletedData[y] && (value = this.matrix.get(x, y)) < minimalDistance) {
                        minimalX = x;
                        minimalY = y;
                        minimalDistance = value;
                    }
                    ++y;
                }
            }
            ++x;
        }
        Agglomeration agglomeration = new Agglomeration(this.clusterIds[minimalX], this.clusterIds[minimalY], minimalDistance);
        this.updateDistances(this.matrix, minimalX, minimalY, clusterMap);
        this.isDeletedData[minimalY] = true;
        this.clusterIds[minimalX] = nextClusterId;
        return agglomeration;
    }

    public abstract void updateDistances(DistanceMatrix var1, int var2, int var3, Map<Integer, HierarchicalClusterNode> var4);
}

