/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.operator.features.construction.ExampleSetBasedIndividual;
import com.rapidminer.operator.features.construction.ExampleSetBasedPopulation;
import com.rapidminer.operator.features.construction.ExampleSetBasedPopulationOperator;
import java.util.LinkedList;
import java.util.Random;

public class ExampleSetBasedTournamentSelection
implements ExampleSetBasedPopulationOperator {
    private int popSize;
    private double tournamentFraction;
    private double delta = 0.0;
    private boolean keepBest = false;
    private Random random;

    public ExampleSetBasedTournamentSelection(int popSize, double tournamentFraction, int maxGenerations, boolean dynamic, boolean keepBest, Random random) {
        this.popSize = popSize;
        this.keepBest = keepBest;
        this.tournamentFraction = tournamentFraction;
        if (dynamic) {
            this.delta = (1.0 - this.tournamentFraction) / (double)(maxGenerations + 1);
        }
        this.random = random;
    }

    public boolean performOperation(int generation) {
        return true;
    }

    public void operate(ExampleSetBasedPopulation population) {
        LinkedList<ExampleSetBasedIndividual> newGeneration = new LinkedList<ExampleSetBasedIndividual>();
        int tournamentSize = Math.max((int)Math.round((double)population.getNumberOfIndividuals() * this.tournamentFraction), 1);
        if (this.keepBest) {
            newGeneration.add(population.getBestIndividualEver());
        }
        while (newGeneration.size() < this.popSize) {
            ExampleSetBasedIndividual winner = null;
            int k = 0;
            while (k < tournamentSize) {
                ExampleSetBasedIndividual current = population.get(this.random.nextInt(population.getNumberOfIndividuals()));
                if (winner == null || current.getPerformance().getMainCriterion().getFitness() > winner.getPerformance().getMainCriterion().getFitness()) {
                    winner = current;
                }
                ++k;
            }
            newGeneration.add(winner);
        }
        population.clear();
        population.addAllIndividuals(newGeneration);
        this.tournamentFraction += this.delta;
    }
}

