/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.generator.AbsoluteValueGenerator;
import com.rapidminer.generator.ExponentialFunctionGenerator;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.generator.FloorCeilGenerator;
import com.rapidminer.generator.MinMaxGenerator;
import com.rapidminer.generator.PowerGenerator;
import com.rapidminer.generator.SignumGenerator;
import com.rapidminer.generator.SquareRootGenerator;
import com.rapidminer.generator.TrigonometricFunctionGenerator;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.construction.ConstantGeneration;
import com.rapidminer.operator.features.construction.EquivalentAttributeRemoval;
import com.rapidminer.operator.features.construction.ExampleSetBasedPopulationOperator;
import com.rapidminer.operator.features.construction.GeneratingMutation;
import com.rapidminer.operator.features.construction.RemoveUselessAttributes;
import com.rapidminer.operator.features.construction.YAGGA;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YAGGA2
extends YAGGA {
    public static final String PARAMETER_USE_SQUARE_ROOTS = "use_square_roots";
    public static final String PARAMETER_USE_POWER_FUNCTIONS = "use_power_functions";
    public static final String PARAMETER_USE_SIN = "use_sin";
    public static final String PARAMETER_USE_COS = "use_cos";
    public static final String PARAMETER_USE_TAN = "use_tan";
    public static final String PARAMETER_USE_ATAN = "use_atan";
    public static final String PARAMETER_USE_EXP = "use_exp";
    public static final String PARAMETER_USE_LOG = "use_log";
    public static final String PARAMETER_USE_ABSOLUTE_VALUES = "use_absolute_values";
    public static final String PARAMETER_USE_MIN = "use_min";
    public static final String PARAMETER_USE_MAX = "use_max";
    public static final String PARAMETER_USE_SGN = "use_sgn";
    public static final String PARAMETER_USE_FLOOR_CEIL_FUNCTIONS = "use_floor_ceil_functions";
    public static final String PARAMETER_RESTRICTIVE_SELECTION = "restrictive_selection";
    public static final String PARAMETER_REMOVE_USELESS = "remove_useless";
    public static final String PARAMETER_REMOVE_EQUIVALENT = "remove_equivalent";
    public static final String PARAMETER_EQUIVALENCE_SAMPLES = "equivalence_samples";
    public static final String PARAMETER_EQUIVALENCE_EPSILON = "equivalence_epsilon";
    public static final String PARAMETER_EQUIVALENCE_USE_STATISTICS = "equivalence_use_statistics";
    public static final String PARAMETER_UNUSED_FUNCTIONS = "unused_functions";
    public static final String PARAMETER_CONSTANT_GENERATION_PROB = "constant_generation_prob";
    public static final String PARAMETER_ASSOCIATIVE_ATTRIBUTE_MERGING = "associative_attribute_merging";

    public YAGGA2(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        if (this.getParameterAsBoolean(PARAMETER_RESTRICTIVE_SELECTION)) {
            FeatureGenerator.setSelectionMode(1);
        } else {
            FeatureGenerator.setSelectionMode(0);
        }
        return super.apply();
    }

    @Override
    protected ExampleSetBasedPopulationOperator getMutationPopulationOperator(ExampleSet exampleSet) throws OperatorException {
        GeneratingMutation mutation = (GeneratingMutation)super.getMutationPopulationOperator(exampleSet);
        String unused = this.getParameterAsString(PARAMETER_UNUSED_FUNCTIONS);
        if (unused != null) {
            mutation.setUnusedFunctions(unused.split(" "));
        }
        return mutation;
    }

    @Override
    public List<FeatureGenerator> getGenerators() {
        List<FeatureGenerator> generators = super.getGenerators();
        if (this.getParameterAsBoolean(PARAMETER_USE_SQUARE_ROOTS)) {
            generators.add(new SquareRootGenerator());
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_POWER_FUNCTIONS)) {
            generators.add(new PowerGenerator());
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_SIN)) {
            generators.add(new TrigonometricFunctionGenerator(0));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_COS)) {
            generators.add(new TrigonometricFunctionGenerator(1));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_TAN)) {
            generators.add(new TrigonometricFunctionGenerator(2));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_ATAN)) {
            generators.add(new TrigonometricFunctionGenerator(3));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_EXP)) {
            generators.add(new ExponentialFunctionGenerator(0));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_LOG)) {
            generators.add(new ExponentialFunctionGenerator(1));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_ABSOLUTE_VALUES)) {
            generators.add(new AbsoluteValueGenerator());
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_MIN)) {
            generators.add(new MinMaxGenerator(0));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_MAX)) {
            generators.add(new MinMaxGenerator(1));
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_SGN)) {
            generators.add(new SignumGenerator());
        }
        if (this.getParameterAsBoolean(PARAMETER_USE_FLOOR_CEIL_FUNCTIONS)) {
            generators.add(new FloorCeilGenerator(0));
            generators.add(new FloorCeilGenerator(1));
            generators.add(new FloorCeilGenerator(2));
        }
        return generators;
    }

    @Override
    protected List<ExampleSetBasedPopulationOperator> getPreProcessingPopulationOperators(ExampleSet eSet) throws OperatorException {
        List<ExampleSetBasedPopulationOperator> popOps = super.getPreProcessingPopulationOperators(eSet);
        double constantProb = this.getParameterAsDouble(PARAMETER_CONSTANT_GENERATION_PROB);
        if (constantProb > 0.0) {
            popOps.add(new ConstantGeneration(constantProb, this.getRandom()));
        }
        if (this.getParameterAsBoolean(PARAMETER_REMOVE_USELESS)) {
            popOps.add(new RemoveUselessAttributes());
        }
        if (this.getParameterAsBoolean(PARAMETER_REMOVE_EQUIVALENT)) {
            popOps.add(new EquivalentAttributeRemoval(this.getParameterAsInt(PARAMETER_EQUIVALENCE_SAMPLES), this.getParameterAsDouble(PARAMETER_EQUIVALENCE_EPSILON), this.getParameterAsBoolean(PARAMETER_EQUIVALENCE_USE_STATISTICS), this.getRandom()));
        }
        return popOps;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_USE_SQUARE_ROOTS, "Generate square root values.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_POWER_FUNCTIONS, "Generate the power of one attribute and another.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_SIN, "Generate sinus.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_COS, "Generate cosinus.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_TAN, "Generate tangens.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_ATAN, "Generate arc tangens.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_EXP, "Generate exponential functions.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_LOG, "Generate logarithmic functions.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_ABSOLUTE_VALUES, "Generate absolute values.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_MIN, "Generate minimum values.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_MAX, "Generate maximum values.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_SGN, "Generate signum values.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_FLOOR_CEIL_FUNCTIONS, "Generate floor, ceil, and rounded values.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_RESTRICTIVE_SELECTION, "Use restrictive generator selection (faster).", true));
        types.add(new ParameterTypeBoolean(PARAMETER_REMOVE_USELESS, "Remove useless attributes.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_REMOVE_EQUIVALENT, "Remove equivalent attributes.", true));
        types.add(new ParameterTypeInt(PARAMETER_EQUIVALENCE_SAMPLES, "Check this number of samples to prove equivalency.", 1, Integer.MAX_VALUE, 5));
        types.add(new ParameterTypeDouble(PARAMETER_EQUIVALENCE_EPSILON, "Consider two attributes equivalent if their difference is not bigger than epsilon.", 0.0, Double.POSITIVE_INFINITY, 0.05));
        types.add(new ParameterTypeBoolean(PARAMETER_EQUIVALENCE_USE_STATISTICS, "Recalculates attribute statistics before equivalence check.", true));
        types.add(new ParameterTypeString(PARAMETER_UNUSED_FUNCTIONS, "Space separated list of functions which are not allowed in arguments for attribute construction."));
        types.add(new ParameterTypeDouble(PARAMETER_CONSTANT_GENERATION_PROB, "Generate random constant attributes with this probability.", 0.0, 1.0, 0.02));
        types.add(new ParameterTypeBoolean(PARAMETER_ASSOCIATIVE_ATTRIBUTE_MERGING, "Post processing after crossover (only possible for runs with only one generator).", false));
        return types;
    }
}

