/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.weighting.AbstractWeighting;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameBasedWeighting
extends AbstractWeighting {
    public static final String PARAMETER_ATTRIBUTE_NAME_REGEX = "name_regex_to_weights";
    public static final String PARAMETER_DISTRIBUTE_WEIGHTS = "distribute_weights";
    public static final String PARAMETER_DEFAULT_WEIGHT = "default_weight";

    public NameBasedWeighting(OperatorDescription description) {
        super(description);
    }

    @Override
    public AttributeWeights calculateWeights(ExampleSet exampleSet) throws OperatorException {
        boolean distributeWeights = this.getParameterAsBoolean(PARAMETER_DISTRIBUTE_WEIGHTS);
        double defaultWeight = this.getParameterAsDouble(PARAMETER_DEFAULT_WEIGHT);
        AttributeWeights attributeWeights = new AttributeWeights();
        for (Attribute attribute : exampleSet.getAttributes()) {
            attributeWeights.setWeight(attribute.getName(), defaultWeight);
        }
        List<String[]> parameterList = this.getParameterList(PARAMETER_ATTRIBUTE_NAME_REGEX);
        for (String[] entry : parameterList) {
            Pattern pattern = Pattern.compile(entry[0]);
            double weight = Double.valueOf(entry[1]);
            if (distributeWeights) {
                int count = 0;
                for (Attribute attribute : exampleSet.getAttributes()) {
                    if (!pattern.matcher(attribute.getName()).matches()) continue;
                    ++count;
                }
                for (Attribute attribute : exampleSet.getAttributes()) {
                    if (!pattern.matcher(attribute.getName()).matches()) continue;
                    attributeWeights.setWeight(attribute.getName(), weight / (double)count);
                }
                continue;
            }
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (!pattern.matcher(attribute.getName()).matches()) continue;
                attributeWeights.setWeight(attribute.getName(), weight);
            }
        }
        return attributeWeights;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeList type = new ParameterTypeList(PARAMETER_ATTRIBUTE_NAME_REGEX, "This list maps different regular expressions for the feature names to the specified weights.", new ParameterTypeDouble("weight", "The new weight for all attributes with a name fulfilling the specified regular expression.", Double.NEGATIVE_INFINITY, Double.MAX_VALUE, false));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_DISTRIBUTE_WEIGHTS, "If enabled, the weights specified in the list are split and distributed equally among the attributes matching the corresponding regular expressions.", false));
        types.add(new ParameterTypeDouble(PARAMETER_DEFAULT_WEIGHT, "This default weight is used for all features not covered by any of the regular expressions given in the list.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0));
        return types;
    }
}

