/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamProfitExampleSetGenerator
extends AbstractExampleSource {
    public static final String PARAMETER_NUMBER_EXAMPLES = "number_examples";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private static String[] ATTRIBUTE_NAMES = new String[]{"size", "leader", "number of qualified employees", "leader changed", "average years of experience", "structure"};
    private static int[] VALUE_TYPES = new int[]{3, 1, 3, 6, 3, 6};
    private static String[][] POSSIBLE_VALUES;

    static {
        String[][] stringArrayArray = new String[6][];
        stringArrayArray[1] = new String[]{"Mr. Brown", "Mr. Miller", "Mrs. Smith", "Mrs. Hanson", "Mrs. Green", "Mr. Chang"};
        stringArrayArray[3] = new String[]{"yes", "no"};
        stringArrayArray[5] = new String[]{"flat", "hierachical"};
        POSSIBLE_VALUES = stringArrayArray;
    }

    public TeamProfitExampleSetGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt(PARAMETER_NUMBER_EXAMPLES);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute id = AttributeFactory.createAttribute("teamID", 1);
        attributes.add(id);
        int m = 0;
        while (m < ATTRIBUTE_NAMES.length) {
            Attribute current = AttributeFactory.createAttribute(ATTRIBUTE_NAMES[m], VALUE_TYPES[m]);
            String[] possibleValues = POSSIBLE_VALUES[m];
            if (possibleValues != null) {
                int v = 0;
                while (v < possibleValues.length) {
                    current.getMapping().mapString(possibleValues[v]);
                    ++v;
                }
            }
            attributes.add(current);
            ++m;
        }
        Attribute label = AttributeFactory.createAttribute("label", 6);
        label.getMapping().mapString("good");
        label.getMapping().mapString("bad");
        attributes.add(label);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        int n = 0;
        while (n < numberOfExamples) {
            double[] values = new double[ATTRIBUTE_NAMES.length + 2];
            values[0] = ((Attribute)attributes.get(0)).getMapping().mapString("team_" + n);
            values[1] = random.nextIntInRange(5, 20);
            values[2] = random.nextInt(POSSIBLE_VALUES[1].length);
            values[3] = Math.round(random.nextDouble() * (values[1] - 1.0) + 1.0);
            values[4] = random.nextInt(POSSIBLE_VALUES[3].length);
            values[5] = random.nextIntInRange(1, 10);
            values[6] = random.nextInt(POSSIBLE_VALUES[5].length);
            values[7] = label.getMapping().mapString("bad");
            if (values[1] > 18.0) {
                if (random.nextDouble() > 0.05) {
                    values[7] = label.getMapping().mapString("good");
                }
            } else if (values[1] > 15.0) {
                if (random.nextDouble() > 0.1) {
                    values[7] = label.getMapping().mapString("good");
                }
            } else if (values[4] == 1.0 && random.nextDouble() > 0.1) {
                values[7] = label.getMapping().mapString("good");
            }
            table.addDataRow(new DoubleArrayDataRow(values));
            ++n;
        }
        return table.createExampleSet(label);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_EXAMPLES, "The number of generated examples.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

