/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.tools.XMLSerialization;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOContainerReader
extends Operator {
    public static final String PARAMETER_FILENAME = "filename";
    public static final String PARAMETER_METHOD = "method";
    public static final String PARAMETER_LOGFILE = "logfile";
    public static final String[] METHODS = new String[]{"append", "prepend", "replace"};
    public static final int APPEND = 0;
    public static final int PREPEND = 1;
    public static final int REPLACE = 2;

    public IOContainerReader(OperatorDescription description) {
        super(description);
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        IOContainer content;
        block26: {
            InputStream in;
            IOContainer input = this.getInput();
            File file = this.getParameterAsFile(PARAMETER_FILENAME);
            try {
                in = new GZIPInputStream(new FileInputStream(file));
            }
            catch (IOException e1) {
                try {
                    in = new FileInputStream(file);
                }
                catch (IOException e) {
                    throw new UserError((Operator)this, (Throwable)e, 302, file, e.getMessage());
                }
            }
            content = null;
            try {
                content = (IOContainer)XMLSerialization.getXMLSerialization().fromXML(in);
                in.close();
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, 302, file, e.getMessage());
            }
            switch (this.getParameterAsInt(PARAMETER_METHOD)) {
                case 0: {
                    content = content.append(input.getIOObjects());
                    break;
                }
                case 1: {
                    content = content.prepend(input.getIOObjects());
                }
            }
            if (this.getParameterAsString(PARAMETER_LOGFILE) != null) {
                File logFile = this.getParameterAsFile(PARAMETER_LOGFILE);
                BufferedReader logIn = null;
                try {
                    try {
                        logIn = new BufferedReader(new FileReader(logFile));
                        String line = null;
                        while ((line = logIn.readLine()) != null) {
                            this.log(line);
                        }
                    }
                    catch (IOException e) {
                        this.logWarning("Could not read from logfile: " + e.toString());
                        if (logIn != null) {
                            try {
                                logIn.close();
                            }
                            catch (IOException e2) {
                                this.logError("Cannot close stream to file " + logFile);
                            }
                        }
                        break block26;
                    }
                }
                catch (Throwable throwable) {
                    if (logIn != null) {
                        try {
                            logIn.close();
                        }
                        catch (IOException e) {
                            this.logError("Cannot close stream to file " + logFile);
                        }
                    }
                    throw throwable;
                }
                if (logIn != null) {
                    try {
                        logIn.close();
                    }
                    catch (IOException e) {
                        this.logError("Cannot close stream to file " + logFile);
                    }
                }
            }
        }
        return content.getIOObjects();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeFile(PARAMETER_FILENAME, "Name of file to write the output to.", "ioc", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_METHOD, "Append or prepend the contents of the file to this operators input or replace this operators input?", METHODS, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeFile(PARAMETER_LOGFILE, "Name of file to read log information from (optional).", "log", true);
        types.add(type);
        return types;
    }
}

