/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractReader;
import com.rapidminer.operator.meta.ParameterSet;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterSetLoader
extends AbstractReader<ParameterSet> {
    public static final String PARAMETER_PARAMETER_FILE = "parameter_file";

    public ParameterSetLoader(OperatorDescription description) {
        super(description, ParameterSet.class);
    }

    @Override
    public ParameterSet read() throws OperatorException {
        ParameterSet parameterSet = null;
        File parameterFile = this.getParameterAsFile(PARAMETER_PARAMETER_FILE);
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(parameterFile);
                parameterSet = ParameterSet.readParameterSet(in);
            }
            catch (IOException e) {
                throw new UserError((Operator)this, 302, e, new Object[]{parameterFile, e.getMessage()});
            }
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    this.logError("Cannot close stream to file " + parameterFile);
                }
            }
        }
        return parameterSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_PARAMETER_FILE, "A file containing a parameter set.", "par", false));
        return types;
    }
}

