/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.Learner;
import com.rapidminer.operator.learner.LearnerCapability;

public class CapabilityCheck {
    private Learner learner;
    private boolean onlyWarn;

    public CapabilityCheck(Learner learner, boolean onlyWarn) {
        this.learner = learner;
        this.onlyWarn = onlyWarn;
    }

    public void checkLearnerCapabilities(Operator learningOperator, ExampleSet exampleSet) throws OperatorException {
        try {
            if (Tools.containsValueType(exampleSet, 1)) {
                if (Tools.containsValueType(exampleSet, 6)) {
                    if (!this.learner.supportsCapability(LearnerCapability.BINOMINAL_ATTRIBUTES)) {
                        throw new UserError(learningOperator, 501, LearnerCapability.BINOMINAL_ATTRIBUTES.getDescription());
                    }
                } else if (!this.learner.supportsCapability(LearnerCapability.POLYNOMINAL_ATTRIBUTES)) {
                    throw new UserError(learningOperator, 501, LearnerCapability.POLYNOMINAL_ATTRIBUTES.getDescription());
                }
            }
            if (Tools.containsValueType(exampleSet, 2) && !this.learner.supportsCapability(LearnerCapability.NUMERICAL_ATTRIBUTES)) {
                throw new UserError(learningOperator, 501, LearnerCapability.NUMERICAL_ATTRIBUTES.getDescription());
            }
            if (exampleSet.getAttributes().getLabel().isNominal()) {
                if (exampleSet.getAttributes().getLabel().getMapping().size() == 2) {
                    if (!this.learner.supportsCapability(LearnerCapability.BINOMINAL_CLASS)) {
                        throw new UserError(learningOperator, 501, LearnerCapability.BINOMINAL_CLASS.getDescription());
                    }
                } else if (!this.learner.supportsCapability(LearnerCapability.POLYNOMINAL_CLASS)) {
                    throw new UserError(learningOperator, 501, LearnerCapability.POLYNOMINAL_CLASS.getDescription());
                }
            } else if (exampleSet.getAttributes().getLabel().isNumerical() && !this.learner.supportsCapability(LearnerCapability.NUMERICAL_CLASS)) {
                throw new UserError(learningOperator, 501, LearnerCapability.NUMERICAL_CLASS.getDescription());
            }
        }
        catch (UserError e) {
            if (this.onlyWarn) {
                learningOperator.logWarning(e.getMessage());
            }
            throw e;
        }
    }
}

