/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.associations;

import com.rapidminer.operator.learner.associations.Item;
import com.rapidminer.tools.Tools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrequentItemSet
implements Comparable<FrequentItemSet>,
Cloneable {
    private ArrayList<Item> items;
    private int frequency;

    public FrequentItemSet() {
        this.items = new ArrayList(1);
    }

    public FrequentItemSet(ArrayList<Item> items, int frequency) {
        this.items = items;
        Collections.sort(this.items);
        this.frequency = frequency;
    }

    public void addItem(Item item, int frequency) {
        this.items.add(item);
        Collections.sort(this.items);
        this.frequency = frequency;
    }

    public Collection<Item> getItems() {
        return this.items;
    }

    public Item getItem(int index) {
        return this.items.get(index);
    }

    public int getNumberOfItems() {
        return this.items.size();
    }

    public int getFrequency() {
        return this.frequency;
    }

    @Override
    public int compareTo(FrequentItemSet o) {
        Collection<Item> hisItems = o.getItems();
        if (this.items.size() < hisItems.size()) {
            return -1;
        }
        if (this.items.size() > hisItems.size()) {
            return 1;
        }
        Iterator<Item> iterator = hisItems.iterator();
        for (Item myCurrentItem : this.items) {
            int relation = myCurrentItem.compareTo(iterator.next());
            if (relation == 0) continue;
            return relation;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o instanceof FrequentItemSet) {
            return this.compareTo((FrequentItemSet)o) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.items.hashCode();
    }

    public String getItemsAsString() {
        StringBuffer buffer = new StringBuffer();
        Iterator<Item> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator<Item> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(", frequency: ");
        buffer.append(Tools.formatNumber(this.frequency));
        return buffer.toString();
    }

    public Object clone() {
        return new FrequentItemSet(new ArrayList<Item>(this.items), this.frequency);
    }
}

