/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.associations.fpgrowth;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.associations.BooleanAttributeItem;
import com.rapidminer.operator.learner.associations.FrequentItemSet;
import com.rapidminer.operator.learner.associations.FrequentItemSets;
import com.rapidminer.operator.learner.associations.Item;
import com.rapidminer.operator.learner.associations.fpgrowth.FPTree;
import com.rapidminer.operator.learner.associations.fpgrowth.FPTreeNode;
import com.rapidminer.operator.learner.associations.fpgrowth.Header;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.sun.org.apache.xerces.internal.impl.xpath.regex.RegularExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FPGrowth
extends Operator {
    public static final String PARAMETER_FIND_MIN_NUMBER_OF_ITEMSETS = "find_min_number_of_itemsets";
    public static final String PARAMETER_MIN_NUMBER_OF_ITEMSETS = "min_number_of_itemsets";
    public static final String PARAMETER_POSITIVE_VALUE = "positive_value";
    public static final String PARAMETER_MIN_SUPPORT = "min_support";
    public static final String PARAMETER_MAX_ITEMS = "max_items";
    private static final String PARAMETER_MUST_CONTAIN = "must_contain";
    private static final String PARAMETER_KEEP_EXAMPLE_SET = "keep_example_set";

    public FPGrowth(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Tools.onlyNominalAttributes(exampleSet, "FPGrowth");
        boolean shouldFindMinimumNumber = this.getParameterAsBoolean(PARAMETER_FIND_MIN_NUMBER_OF_ITEMSETS);
        int maxItems = this.getParameterAsInt(PARAMETER_MAX_ITEMS);
        FrequentItemSets rules = null;
        int minimumNumberOfItemsets = this.getParameterAsInt(PARAMETER_MIN_NUMBER_OF_ITEMSETS);
        double currentSupport = 0.95;
        boolean foundEnough = false;
        while (!foundEnough) {
            int minTotalSupport;
            if (shouldFindMinimumNumber) {
                minTotalSupport = (int)Math.ceil(currentSupport * (double)exampleSet.size());
            } else {
                double minSupport = this.getParameterAsDouble(PARAMETER_MIN_SUPPORT);
                minTotalSupport = (int)Math.ceil(minSupport * (double)exampleSet.size());
            }
            ExampleSet workingSet = this.preprocessExampleSet(exampleSet);
            Attribute[] attributes = new Attribute[workingSet.getAttributes().size()];
            double[] positiveIndices = new double[workingSet.getAttributes().size()];
            int i = 0;
            Iterator<Attribute> iterator = workingSet.getAttributes().iterator();
            while (iterator.hasNext()) {
                Attribute attribute;
                attributes[i] = attribute = iterator.next();
                positiveIndices[i] = attribute.getMapping().getPositiveIndex();
                String positiveValueString = null;
                try {
                    positiveValueString = this.getParameterAsString(PARAMETER_POSITIVE_VALUE);
                }
                catch (UndefinedParameterError undefinedParameterError) {
                    // empty catch block
                }
                if (positiveValueString != null && !positiveValueString.equals("")) {
                    positiveIndices[i] = attribute.getMapping().mapString(positiveValueString);
                }
                ++i;
            }
            Map<Attribute, Item> itemMapping = this.getAttributeMapping(workingSet);
            this.getItemFrequency(workingSet, attributes, positiveIndices, itemMapping);
            this.removeNonFrequentItems(itemMapping, minTotalSupport, workingSet);
            FPTree tree = this.getFPTree(workingSet, attributes, positiveIndices, itemMapping);
            rules = new FrequentItemSets(workingSet.size());
            String mustContainItems = this.getParameterAsString(PARAMETER_MUST_CONTAIN);
            if (mustContainItems == null) {
                this.mineTree(tree, rules, 0, minTotalSupport, maxItems);
            } else {
                FrequentItemSet conditionalItems = new FrequentItemSet();
                RegularExpression regEx = new RegularExpression(mustContainItems);
                for (Attribute attribute : itemMapping.keySet()) {
                    if (!regEx.matches(attribute.getName())) continue;
                    Item targetItem = itemMapping.get(attribute);
                    conditionalItems.addItem(targetItem, targetItem.getFrequency());
                }
                rules.addFrequentSet(conditionalItems);
                this.mineTree(tree, rules, 0, conditionalItems, minTotalSupport, maxItems);
            }
            if (!shouldFindMinimumNumber) break;
            if (rules.size() >= minimumNumberOfItemsets || currentSupport <= 0.06) {
                foundEnough = true;
            }
            currentSupport -= 0.05;
        }
        if (this.getParameterAsBoolean(PARAMETER_KEEP_EXAMPLE_SET)) {
            return new IOObject[]{exampleSet, rules};
        }
        return new IOObject[]{rules};
    }

    private ExampleSet preprocessExampleSet(ExampleSet exampleSet) {
        ExampleSet workingSet = (ExampleSet)exampleSet.clone();
        int oldAttributeCount = workingSet.getAttributes().size();
        this.removeNonBooleanAttributes(workingSet);
        int newAttributeCount = workingSet.getAttributes().size();
        if (oldAttributeCount != newAttributeCount) {
            int removeCount = oldAttributeCount - newAttributeCount;
            String message = null;
            message = removeCount == 1 ? "Removed 1 non-binominal attribute, frequent item set mining is only supported for the positive values of binominal attributes." : "Removed " + removeCount + " non-binominal attributes, frequent item set mining is only supported for the positive values of binominal attributes.";
            this.logWarning(message);
        }
        return workingSet;
    }

    private void mineTree(FPTree tree, FrequentItemSets rules, int recursionDepth, int minTotalSupport, int maxItems) {
        this.mineTree(tree, rules, recursionDepth, new FrequentItemSet(), minTotalSupport, maxItems);
    }

    private void mineTree(FPTree tree, FrequentItemSets rules, int recursionDepth, FrequentItemSet conditionalItems, int minTotalSupport, int maxItems) {
        if (!this.treeIsEmpty(tree, recursionDepth)) {
            if (maxItems > 0 && recursionDepth >= maxItems) {
                return;
            }
            Map<Item, Header> headerTable = tree.getHeaderTable();
            for (Map.Entry<Item, Header> headerEntry : headerTable.entrySet()) {
                FPTreeNode currentNode;
                Item item = headerEntry.getKey();
                Header itemHeader = headerEntry.getValue();
                int itemSupport = itemHeader.getFrequencies().getFrequency(recursionDepth);
                if (itemSupport < minTotalSupport) continue;
                for (FPTreeNode node : itemHeader.getSiblingChain()) {
                    int frequency = node.getFrequency(recursionDepth);
                    if (frequency <= 0) continue;
                    currentNode = node.getFather();
                    while (currentNode != tree) {
                        currentNode.increaseFrequency(recursionDepth + 1, frequency);
                        headerTable.get(currentNode.getNodeItem()).getFrequencies().increaseFrequency(recursionDepth + 1, frequency);
                        currentNode = currentNode.getFather();
                    }
                }
                FrequentItemSet recursivConditionalItems = (FrequentItemSet)conditionalItems.clone();
                recursivConditionalItems.addItem(item, itemSupport);
                rules.addFrequentSet(recursivConditionalItems);
                this.mineTree(tree, rules, recursionDepth + 1, recursivConditionalItems, minTotalSupport, maxItems);
                for (FPTreeNode node : itemHeader.getSiblingChain()) {
                    currentNode = node.getFather();
                    while (currentNode != tree) {
                        currentNode.popFrequency(recursionDepth + 1);
                        currentNode = currentNode.getFather();
                    }
                }
                for (Header currentItemHeader : headerTable.values()) {
                    currentItemHeader.getFrequencies().popFrequency(recursionDepth + 1);
                }
            }
        }
    }

    private void removeNonBooleanAttributes(ExampleSet exampleSet) {
        ArrayList<Attribute> deleteAttributes = new ArrayList<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (attribute.isNominal() && attribute.getMapping().size() == 2) continue;
            deleteAttributes.add(attribute);
        }
        for (Attribute attribute : deleteAttributes) {
            exampleSet.getAttributes().remove(attribute);
        }
    }

    private Map<Attribute, Item> getAttributeMapping(ExampleSet exampleSet) {
        HashMap<Attribute, Item> mapping = new HashMap<Attribute, Item>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            mapping.put(attribute, new BooleanAttributeItem(attribute));
        }
        return mapping;
    }

    private void getItemFrequency(ExampleSet exampleSet, Attribute[] attributes, double[] positiveIndices, Map<Attribute, Item> mapping) {
        for (Example currentExample : exampleSet) {
            int i = 0;
            Attribute[] attributeArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute attribute = attributeArray[n2];
                if (currentExample.getValue(attribute) == positiveIndices[i]) {
                    mapping.get(attribute).increaseFrequency();
                }
                ++i;
                ++n2;
            }
        }
    }

    private void removeNonFrequentItems(Map<Attribute, Item> mapping, int minFrequency, ExampleSet exampleSet) {
        ArrayList<Attribute> deleteMappings = new ArrayList<Attribute>();
        for (Map.Entry<Attribute, Item> entry : mapping.entrySet()) {
            if (entry.getValue().getFrequency() >= minFrequency) continue;
            deleteMappings.add(entry.getKey());
        }
        for (Attribute attribute : deleteMappings) {
            exampleSet.getAttributes().remove(attribute);
        }
    }

    private FPTree getFPTree(ExampleSet exampleSet, Attribute[] attributes, double[] positiveIndices, Map<Attribute, Item> mapping) {
        FPTree tree = new FPTree();
        for (Example currentExample : exampleSet) {
            ArrayList<Item> itemSet = new ArrayList<Item>();
            int i = 0;
            Attribute[] attributeArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute currentAttribute = attributeArray[n2];
                if (currentExample.getValue(currentAttribute) == positiveIndices[i]) {
                    itemSet.add(mapping.get(currentAttribute));
                }
                ++i;
                ++n2;
            }
            Collections.sort(itemSet);
            tree.addItemSet(itemSet, 1);
        }
        return tree;
    }

    private boolean treeIsEmpty(FPTree tree, int recursionDepth) {
        for (FPTreeNode node : tree.getChildren().values()) {
            if (node.getFrequency(recursionDepth) <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{FrequentItemSets.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_EXAMPLE_SET, "indicates if example set is kept", false));
        ParameterTypeSingle type = new ParameterTypeBoolean(PARAMETER_FIND_MIN_NUMBER_OF_ITEMSETS, "Indicates if the support should be decreased until the specified minimum number of frequent item sets is found. Otherwise, FPGrowth simply uses the defined support.", true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MIN_NUMBER_OF_ITEMSETS, "Indicates the minimum number of itemsets which should be determined if the corresponding parameter is activated.", 0, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeString(PARAMETER_POSITIVE_VALUE, "This parameter determines, which value of the binominal attributes is treated as positive. Attributes with that value are considered as part of a transaction. If left blank, the example set determines, which is value is used.", true);
        type.setExpert(true);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_MIN_SUPPORT, "The minimal support necessary in order to be a frequent item (set).", 0.0, 1.0, 0.95));
        types.add(new ParameterTypeInt(PARAMETER_MAX_ITEMS, "The upper bound for the length of the item sets (-1: no upper bound)", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeString(PARAMETER_MUST_CONTAIN, "The items any generated rule must contain as regular expression. Empty if none."));
        return types;
    }
}

