/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.bayes;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.operator.learner.bayes.KernelDistributionModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KernelNaiveBayes
extends AbstractLearner {
    public static final String PARAMETER_LAPLACE_CORRECTION = "laplace_correction";
    public static final String PARAMETER_ESTIMATION_MODE = "estimation_mode";
    public static final String[] ESTIMATION_MODES = new String[]{"full", "greedy"};
    public static final int ESTIMATION_MODE_FULL = 0;
    public static final int ESTIMATION_MODE_GREEDY = 1;
    public static final String PARAMETER_BANDWIDTH_SELECTION = "bandwidth_selection";
    public static final String[] BANDWIDTH_SELECTION_MODES = new String[]{"heuristic", "fix"};
    public static final int BANDWIDTH_SELECTION_MODE_HEURISTIC = 0;
    public static final int BANDWIDTH_SELECTION_MODE_FIX = 1;
    public static final String PARAMETER_BANDWIDTH = "bandwidth";
    public static final String PARAMETER_MINIMUM_BANDWIDTH = "minimum_bandwidth";
    public static final String PARAMETER_NUMBER_OF_KERNELS = "number_of_kernels";
    public static final String PARAMETER_USE_APPLICATION_GRID = "use_application_grid";
    public static final String PARAMETER_APPLICATION_GRID_SIZE = "application_grid_size";

    public KernelNaiveBayes(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        int estimationMode = this.getParameterAsInt(PARAMETER_ESTIMATION_MODE);
        double bandwidth = estimationMode == 0 ? this.getParameterAsDouble(PARAMETER_BANDWIDTH) : this.getParameterAsDouble(PARAMETER_MINIMUM_BANDWIDTH);
        int gridSize = this.getParameterAsBoolean(PARAMETER_USE_APPLICATION_GRID) ? this.getParameterAsInt(PARAMETER_APPLICATION_GRID_SIZE) : 0;
        return new KernelDistributionModel(exampleSet, this.getParameterAsBoolean(PARAMETER_LAPLACE_CORRECTION), estimationMode, this.getParameterAsInt(PARAMETER_BANDWIDTH_SELECTION), bandwidth, this.getParameterAsInt(PARAMETER_NUMBER_OF_KERNELS), gridSize);
    }

    @Override
    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.POLYNOMINAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.POLYNOMINAL_CLASS) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_CLASS) {
            return true;
        }
        if (lc == LearnerCapability.WEIGHTED_EXAMPLES) {
            return true;
        }
        return lc == LearnerCapability.UPDATABLE;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeBoolean(PARAMETER_LAPLACE_CORRECTION, "Use Laplace correction to prevent high influence of zero probabilities.", true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_ESTIMATION_MODE, "The kernel density estimation mode.", ESTIMATION_MODES, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_BANDWIDTH_SELECTION, "The method to set the kernel bandwidth.", BANDWIDTH_SELECTION_MODES, 0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_ESTIMATION_MODE, false, 0));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_BANDWIDTH, "Kernel bandwidth.", Double.MIN_VALUE, Double.POSITIVE_INFINITY, 0.1);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_BANDWIDTH_SELECTION, false, 1));
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_ESTIMATION_MODE, false, 0));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_MINIMUM_BANDWIDTH, "Minimum kernel bandwidth.", Double.MIN_VALUE, Double.POSITIVE_INFINITY, 0.1);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_ESTIMATION_MODE, false, 1));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_KERNELS, "Number of kernels.", 1, Integer.MAX_VALUE, 10);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_ESTIMATION_MODE, false, 1));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_USE_APPLICATION_GRID, "Use a kernel density function grid in model application. (Speeds up model application at the expense of the density function precision.)", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_APPLICATION_GRID_SIZE, "Size of the application grid.", 10, Integer.MAX_VALUE, 200);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_APPLICATION_GRID, false, true));
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

