/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.operator.learner.functions.kernel.AbstractMySVMLearner;
import com.rapidminer.operator.learner.functions.kernel.AbstractMySVMModel;
import com.rapidminer.operator.learner.functions.kernel.MyKLRModel;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.examples.SVMExamples;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.Kernel;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.svm.SVMInterface;
import com.rapidminer.operator.learner.functions.kernel.logistic.KLR;
import com.rapidminer.parameter.ParameterType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyKLRLearner
extends AbstractMySVMLearner {
    public MyKLRLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        return lc == LearnerCapability.BINOMINAL_CLASS;
    }

    @Override
    public AbstractMySVMModel createSVMModel(ExampleSet exampleSet, SVMExamples sVMExamples, Kernel kernel, int kernelType) {
        return new MyKLRModel(exampleSet, sVMExamples, kernel, kernelType);
    }

    @Override
    public SVMInterface createSVM(Attribute label, Kernel kernel, SVMExamples sVMExamples, ExampleSet rapidMinerExamples) throws OperatorException {
        if (!label.isNominal()) {
            throw new UserError((Operator)this, 101, "MyKLR", label.getName());
        }
        return new KLR(this);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        for (ParameterType type : types) {
            if (!type.getKey().equals("C")) continue;
            type.setDefaultValue(1.0);
        }
        return types;
    }
}

