/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel;

import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.Kernel;

public class KernelMultiquadric
extends Kernel {
    private static final long serialVersionUID = -9152135200919885773L;
    private double sigma = 1.0;
    private double shift = 1.0;

    public String toString() {
        return "multiquadric(sigma=" + this.sigma + ",shift=" + this.shift + ")";
    }

    public void setParameters(double sigma, double shift) {
        this.sigma = sigma;
        this.shift = shift;
    }

    public double calculate_K(int[] x_index, double[] x_att, int[] y_index, double[] y_att) {
        return Math.sqrt(this.norm2(x_index, x_att, y_index, y_att) / this.sigma + this.shift * this.shift);
    }

    public String getDistanceFormula(double[] x, String[] attributeConstructions) {
        StringBuffer norm2Expression = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < x.length) {
            double value = x[i];
            String valueString = "(" + value + " - " + attributeConstructions[i] + ")";
            if (first) {
                norm2Expression.append(String.valueOf(valueString) + " * " + valueString);
            } else {
                norm2Expression.append(" + " + valueString + " * " + valueString);
            }
            first = false;
            ++i;
        }
        return "sqrt((" + norm2Expression + " / " + this.sigma + ") + (" + this.shift + " * " + this.shift + "))";
    }
}

