/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.jmysvm.optimizer;

import com.rapidminer.operator.learner.functions.kernel.jmysvm.optimizer.QuadraticProblem;

public class QuadraticProblemSMO
extends QuadraticProblem {
    protected double[] sum;
    protected double is_zero;
    protected int max_iteration;

    public QuadraticProblemSMO() {
        this.is_zero = 1.0E-10;
        this.max_allowed_error = 0.001;
        this.max_iteration = 10000;
    }

    public void set_n(int new_n) {
        super.set_n(new_n);
        this.sum = new double[this.n];
    }

    public QuadraticProblemSMO(double is_zero, double max_allowed_error, int max_iteration) {
        this.is_zero = is_zero;
        this.max_allowed_error = max_allowed_error;
        this.max_iteration = max_iteration;
    }

    protected final double x2tox1(double x2, boolean id, double A1, double b) {
        double x1 = id ? -x2 : x2;
        x1 = A1 > 0.0 ? (x1 += b) : (x1 -= b);
        return x1;
    }

    protected final double x1tox2(double x1, boolean id, double A2, double b) {
        double x2 = id ? -x1 : x1;
        x2 = A2 > 0.0 ? (x2 += b) : (x2 -= b);
        return x2;
    }

    protected final void simple_solve(int i, int j, double H1, double H2, double c0, double c1, double c2, double A1, double A2, double l1, double l2, double u1, double u2) {
        double t;
        double x1 = this.x[i];
        double x2 = this.x[j];
        double den = H1 + H2;
        den = A1 > 0.0 && A2 > 0.0 || A1 < 0.0 && A2 < 0.0 ? (den -= c0) : (den += c0);
        if ((den *= 2.0) != 0.0) {
            double up;
            double lo;
            double num = -2.0 * H1 * x1 - x2 * c0 - c1;
            if (A1 < 0.0) {
                num = -num;
            }
            num = A2 > 0.0 ? (num += 2.0 * H2 * x2 + x1 * c0 + c2) : (num -= 2.0 * H2 * x2 + x1 * c0 + c2);
            t = num / den;
            if (A1 > 0.0) {
                lo = l1 - x1;
                up = u1 - x1;
            } else {
                lo = x1 - u1;
                up = x1 - l1;
            }
            if (A2 < 0.0) {
                if (l2 - x2 > lo) {
                    lo = l2 - x2;
                }
                if (u2 - x2 < up) {
                    up = u2 - x2;
                }
            } else {
                if (x2 - l2 < up) {
                    up = x2 - l2;
                }
                if (x2 - u2 > lo) {
                    lo = x2 - u2;
                }
            }
            if (t < lo) {
                t = lo;
            }
            if (t > up) {
                t = up;
            }
        } else {
            double factor = 2.0 * H1 * x1 + x2 * c0 + c1;
            if (A1 < 0.0) {
                factor = -factor;
            }
            factor = A2 > 0.0 ? (factor -= 2.0 * H2 * x2 + x1 * c0 + c2) : (factor += 2.0 * H2 * x2 + x1 * c0 + c2);
            if (factor > 0.0) {
                t = A1 > 0.0 ? l1 - x1 : x1 - u1;
                if (A2 < 0.0) {
                    if (l2 - x2 > t) {
                        t = l2 - x2;
                    }
                } else if (x2 - u2 > t) {
                    t = x2 - u2;
                }
            } else {
                t = A1 > 0.0 ? u1 - x1 : x1 - l1;
                if (A2 < 0.0) {
                    if (u2 - x2 < t) {
                        t = u2 - x2;
                    }
                } else if (x2 - l2 < t) {
                    t = x2 - l2;
                }
            }
        }
        x1 = A1 > 0.0 ? (x1 += t) : (x1 -= t);
        x2 = A2 > 0.0 ? (x2 -= t) : (x2 += t);
        if (x1 - l1 <= this.is_zero) {
            x1 = l1;
        } else if (x1 - u1 >= -this.is_zero) {
            x1 = u1;
        }
        if (x2 - l2 <= this.is_zero) {
            x2 = l2;
        } else if (x2 - u2 >= -this.is_zero) {
            x2 = u2;
        }
        this.x[i] = x1;
        this.x[j] = x2;
    }

    protected final boolean minimize_ij(int i, int j) {
        boolean ok;
        double sum_i = this.sum[i];
        double sum_j = this.sum[j];
        sum_i -= this.H[i * (this.n + 1)] * this.x[i];
        sum_i -= this.H[i * this.n + j] * this.x[j];
        sum_j -= this.H[j * this.n + i] * this.x[i];
        sum_j -= this.H[j * (this.n + 1)] * this.x[j];
        double old_xi = this.x[i];
        double old_xj = this.x[j];
        this.simple_solve(i, j, this.H[i * (this.n + 1)] / 2.0, this.H[j * (this.n + 1)] / 2.0, this.H[i * this.n + j], sum_i += this.c[i], sum_j += this.c[j], this.A[i], this.A[j], this.l[i], this.l[j], this.u[i], this.u[j]);
        double target = (old_xi - this.x[i]) * (this.H[i * (this.n + 1)] / 2.0 * (old_xi + this.x[i]) + sum_i) + (old_xj - this.x[j]) * (this.H[j * (this.n + 1)] / 2.0 * (old_xj + this.x[j]) + sum_j) + this.H[i * this.n + j] * (old_xi * old_xj - this.x[i] * this.x[j]);
        if (target < 0.0) {
            this.x[i] = old_xi;
            this.x[j] = old_xj;
            old_xi = 0.0;
            old_xj = 0.0;
            ok = false;
        } else {
            old_xi -= this.x[i];
            old_xj -= this.x[j];
            int k = 0;
            while (k < this.n) {
                int n = k;
                this.sum[n] = this.sum[n] - this.H[i * this.n + k] * old_xi;
                int n2 = k;
                this.sum[n2] = this.sum[n2] - this.H[j * this.n + k] * old_xj;
                ++k;
            }
            ok = true;
        }
        ok = Math.abs(old_xi) > this.is_zero || Math.abs(old_xj) > this.is_zero;
        return ok;
    }

    protected final void calc_lambda_eq() {
        double lambda_eq_sum = 0.0;
        int count = 0;
        int i = 0;
        while (i < this.n) {
            if (this.x[i] > this.l[i] && this.x[i] < this.u[i]) {
                lambda_eq_sum = this.A[i] > 0.0 ? (lambda_eq_sum -= this.sum[i] + this.c[i]) : (lambda_eq_sum += this.sum[i] + this.c[i]);
                ++count;
            }
            ++i;
        }
        if (count > 0) {
            lambda_eq_sum /= (double)count;
        } else {
            double lambda_min = Double.NEGATIVE_INFINITY;
            double lambda_max = Double.POSITIVE_INFINITY;
            i = 0;
            while (i < this.n) {
                double nabla = this.sum[i] + this.c[i];
                if (this.x[i] <= this.l[i]) {
                    if (this.A[i] > 0.0) {
                        if (-nabla > lambda_min) {
                            lambda_min = -nabla;
                        }
                    } else if (nabla < lambda_max) {
                        lambda_max = nabla;
                    }
                } else if (this.A[i] > 0.0) {
                    if (-nabla < lambda_max) {
                        lambda_max = -nabla;
                    }
                } else if (nabla > lambda_min) {
                    lambda_min = nabla;
                }
                ++i;
            }
            lambda_eq_sum = lambda_min > Double.NEGATIVE_INFINITY ? (lambda_max < Double.POSITIVE_INFINITY ? (lambda_max + lambda_min) / 2.0 : lambda_min) : lambda_max;
        }
        this.lambda_eq = lambda_eq_sum;
    }

    public final int solve() {
        int error;
        block31: {
            error = 0;
            int i = 0;
            while (i < this.n) {
                this.sum[i] = 0.0;
                int j = 0;
                while (j < this.n) {
                    int n = i;
                    this.sum[n] = this.sum[n] + this.H[i * this.n + j] * this.x[j];
                    ++j;
                }
                ++i;
            }
            int iteration = 0;
            double max_lambda_eq = 0.0;
            double max_error = Double.NEGATIVE_INFINITY;
            double min_error = Double.POSITIVE_INFINITY;
            int max_i = 0;
            int min_i = 1;
            int old_min_i = -1;
            int old_max_i = -1;
            this.calc_lambda_eq();
            do {
                double this_error;
                if (error == 0) {
                    max_error = Double.NEGATIVE_INFINITY;
                    min_error = Double.POSITIVE_INFINITY;
                    max_i = 0;
                    min_i = 1;
                    i = 0;
                    while (i < this.n) {
                        double this_lambda_eq;
                        if (this.x[i] <= this.l[i]) {
                            this_error = -this.sum[i] - this.c[i];
                            if (this.A[i] > 0.0) {
                                this_lambda_eq = this_error;
                                this_error -= this.lambda_eq;
                            } else {
                                this_lambda_eq = -this_error;
                                this_error += this.lambda_eq;
                            }
                        } else if (this.x[i] >= this.u[i]) {
                            this_error = this.sum[i] + this.c[i];
                            if (this.A[i] > 0.0) {
                                this_lambda_eq = -this_error;
                                this_error += this.lambda_eq;
                            } else {
                                this_lambda_eq = this_error;
                                this_error -= this.lambda_eq;
                            }
                        } else {
                            this_error = this.sum[i] + this.c[i];
                            if (this.A[i] > 0.0) {
                                this_lambda_eq = -this_error;
                                this_error += this.lambda_eq;
                            } else {
                                this_lambda_eq = this_error;
                                this_error -= this.lambda_eq;
                            }
                            if (this_error < 0.0) {
                                this_error = -this_error;
                            }
                        }
                        if (this_error > max_error && old_max_i != i) {
                            max_i = i;
                            max_error = this_error;
                            max_lambda_eq = this_lambda_eq;
                        }
                        if (this_error <= min_error && i != old_min_i) {
                            min_i = i;
                            min_error = this_error;
                        }
                        ++i;
                    }
                    old_max_i = max_i;
                    old_min_i = min_i;
                } else {
                    max_i = (max_i + 1) % this.n;
                }
                if (max_error <= this.max_allowed_error) {
                    error = 0;
                    break block31;
                }
                double max_diff = -1.0;
                boolean n_lo = !(this.x[max_i] <= this.l[max_i]);
                boolean n_up = !(this.x[max_i] >= this.u[max_i]);
                min_i = (max_i + 1) % this.n;
                i = 0;
                while (i < this.n) {
                    if (i != max_i && (n_up || this.x[i] < this.u[i]) && (n_lo || this.x[i] > this.l[i])) {
                        double this_diff;
                        if (this.x[i] <= this.l[i]) {
                            this_error = -this.sum[i] - this.c[i];
                            if (this.A[i] < 0.0) {
                                this_error = -this_error;
                            }
                        } else {
                            this_error = this.sum[i] + this.c[i];
                            if (this.A[i] > 0.0) {
                                this_error = -this_error;
                            }
                        }
                        if ((this_diff = Math.abs(this_error - max_lambda_eq)) > max_diff) {
                            max_diff = this_diff;
                            min_i = i;
                        }
                    }
                    ++i;
                }
                int it = 1;
                while (!this.minimize_ij(min_i, max_i) && it < this.n) {
                    ++it;
                    if ((min_i = (min_i + 1) % this.n) != max_i) continue;
                    min_i = (min_i + 1) % this.n;
                }
                if (it == this.n) {
                    if (++error >= this.n) {
                        break block31;
                    }
                } else {
                    error = 0;
                }
                this.calc_lambda_eq();
            } while (++iteration <= this.max_iteration);
            ++error;
        }
        return error;
    }
}

