/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.lazy;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.PredictionModel;
import java.util.HashMap;

public class AttributeBasedVotingModel
extends PredictionModel {
    private static final long serialVersionUID = -8814468417883548971L;
    private double majorityVote;

    public AttributeBasedVotingModel(ExampleSet exampleSet, double majorityVote) {
        super(exampleSet);
        this.majorityVote = majorityVote;
    }

    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabelAttribute) throws OperatorException {
        for (Example example : exampleSet) {
            if (predictedLabelAttribute.isNominal()) {
                HashMap<String, Double> counter = new HashMap<String, Double>();
                for (Attribute attribute : example.getAttributes()) {
                    if (!attribute.isNominal()) {
                        throw new UserError(null, 103, "nominal voting");
                    }
                    String labelValue = attribute.getMapping().mapIndex((int)example.getValue(attribute));
                    double labelSum = 0.0;
                    if (counter.get(labelValue) != null) {
                        labelSum = (Double)counter.get(labelValue);
                    }
                    counter.put(labelValue, labelSum += 1.0);
                }
                String bestClass = null;
                double best = Double.NEGATIVE_INFINITY;
                for (String labelValue : this.getLabel().getMapping().getValues()) {
                    Double sumObject = (Double)counter.get(labelValue);
                    if (sumObject == null) {
                        example.setConfidence(labelValue, 0.0);
                        continue;
                    }
                    example.setConfidence(labelValue, sumObject / (double)exampleSet.getAttributes().size());
                    if (!(sumObject > best)) continue;
                    best = sumObject;
                    bestClass = labelValue;
                }
                if (bestClass != null) {
                    example.setPredictedLabel(predictedLabelAttribute.getMapping().mapString(bestClass));
                    continue;
                }
                example.setPredictedLabel(this.majorityVote);
                continue;
            }
            double average = 0.0;
            for (Attribute attribute : example.getAttributes()) {
                average += example.getValue(attribute);
            }
            example.setValue(predictedLabelAttribute, average /= (double)example.getAttributes().size());
        }
        return exampleSet;
    }
}

