/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.MappedExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.operator.learner.meta.AbstractMetaLearner;
import com.rapidminer.operator.learner.meta.MetaCostModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeMatrix;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaCost
extends AbstractMetaLearner {
    public static final String PARAMETER_COST_MATRIX = "cost_matrix";
    public static final String PARAMETER_COST_MATRIX_FILE_LOCATION = "cost_matrix_file_location";
    public static final String PARAMETER_USE_SUBSET_FOR_TRAINING = "use_subset_for_training";
    public static final String PARAMETER_ITERATIONS = "iterations";
    public static final String PARAMETER_SAMPLING_WITH_REPLACEMENT = "sampling_with_replacement";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";

    public MetaCost(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet inputSet) throws OperatorException {
        int iterations = this.getParameterAsInt(PARAMETER_ITERATIONS);
        double subsetRatio = this.getParameterAsDouble(PARAMETER_USE_SUBSET_FOR_TRAINING);
        Model[] models = new Model[iterations];
        double[][] costMatrix = this.getParameterAsMatrix(PARAMETER_COST_MATRIX);
        if (this.getParameterAsBoolean(PARAMETER_SAMPLING_WITH_REPLACEMENT)) {
            int randomSeed = this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED);
            RandomGenerator randomGenerator = RandomGenerator.getRandomGenerator(randomSeed);
            int size = (int)((double)inputSet.size() * subsetRatio);
            int i = 0;
            while (i < iterations) {
                ExampleSet exampleSet = (ExampleSet)inputSet.clone();
                int[] mapping = MappedExampleSet.createBootstrappingMapping(exampleSet, size, randomGenerator);
                MappedExampleSet currentSampleSet = new MappedExampleSet(exampleSet, mapping);
                models[i] = this.applyInnerLearner(currentSampleSet);
                this.inApplyLoop();
                ++i;
            }
        } else {
            int i = 0;
            while (i < iterations) {
                SplittedExampleSet splitted = new SplittedExampleSet((ExampleSet)inputSet.clone(), subsetRatio, 1, -1);
                splitted.selectSingleSubset(0);
                models[i] = this.applyInnerLearner(splitted);
                this.inApplyLoop();
                ++i;
            }
        }
        return new MetaCostModel(inputSet, models, costMatrix);
    }

    @Override
    public boolean supportsCapability(LearnerCapability capability) {
        if (this.getNumberOfOperators() == 0) {
            return false;
        }
        if (capability == LearnerCapability.POLYNOMINAL_CLASS) {
            return true;
        }
        if (capability == LearnerCapability.BINOMINAL_CLASS) {
            return true;
        }
        return super.supportsCapability(capability);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeMatrix(PARAMETER_COST_MATRIX, "The cost matrix in Matlab single line format", "Cost Matrix", "Predicted Class", "True Class", true, false));
        types.add(new ParameterTypeDouble(PARAMETER_USE_SUBSET_FOR_TRAINING, "Fraction of examples used for training. Must be greater than 0 and should be lower than 1.", 0.0, 1.0, 1.0));
        types.add(new ParameterTypeInt(PARAMETER_ITERATIONS, "The number of iterations (base models).", 1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeBoolean(PARAMETER_SAMPLING_WITH_REPLACEMENT, "Use sampling with replacement (true) or without (false)", true));
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global)", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

