/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.subgroups.utility;

import com.rapidminer.operator.learner.subgroups.hypothesis.Hypothesis;
import com.rapidminer.operator.learner.subgroups.hypothesis.Rule;
import com.rapidminer.operator.learner.subgroups.utility.Accuracy;
import com.rapidminer.operator.learner.subgroups.utility.Bias;
import com.rapidminer.operator.learner.subgroups.utility.Binomial;
import com.rapidminer.operator.learner.subgroups.utility.Coverage;
import com.rapidminer.operator.learner.subgroups.utility.Lift;
import com.rapidminer.operator.learner.subgroups.utility.Odds;
import com.rapidminer.operator.learner.subgroups.utility.OddsRatio;
import com.rapidminer.operator.learner.subgroups.utility.Precision;
import com.rapidminer.operator.learner.subgroups.utility.Squared;
import com.rapidminer.operator.learner.subgroups.utility.WRAcc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UtilityFunction {
    public static final int COVERAGE = 0;
    public static final int PRECISION = 1;
    public static final int ACCURACY = 2;
    public static final int BIAS = 3;
    public static final int LIFT = 4;
    public static final int BINOMIAL = 5;
    public static final int WRACC = 6;
    public static final int SQUARED = 7;
    public static final int ODDS = 8;
    public static final int ODDS_RATIO = 9;
    public static final String[] FUNCTIONS = new String[]{"Coverage", "Precision", "Accuracy", "Bias", "Lift", "Binomial", "WRAcc", "Squared", "Odds", "Odds Ratio"};
    protected static final int POSITIVE_CLASS = 1;
    protected static final int NEGATIVE_CLASS = 0;
    protected double totalWeight = 0.0;
    protected double totalPositiveWeight = 0.0;
    protected double totalNegativeWeight = 0.0;
    double[] priors = new double[2];

    public UtilityFunction(double totalWeight, double totalPositiveWeight) {
        this.totalWeight = totalWeight;
        this.totalPositiveWeight = totalPositiveWeight;
        this.totalNegativeWeight = totalWeight - totalPositiveWeight;
        this.priors[1] = totalPositiveWeight / totalWeight;
        this.priors[0] = 1.0 - this.priors[1];
    }

    public abstract double utility(Rule var1);

    public abstract double optimisticEstimate(Hypothesis var1);

    public abstract String getName();

    public abstract String getAbbreviation();

    public double getTotalWeight() {
        return this.totalWeight;
    }

    public double getTotalPositiveWeight() {
        return this.totalPositiveWeight;
    }

    public double getTotalNegativeWeight() {
        return this.totalNegativeWeight;
    }

    public static UtilityFunction getUtilityFunction(int utilityFunctionIndex, double totalWeight, double totalPositiveWeight) {
        switch (utilityFunctionIndex) {
            case 0: {
                return new Coverage(totalWeight, totalPositiveWeight);
            }
            case 1: {
                return new Precision(totalWeight, totalPositiveWeight);
            }
            case 2: {
                return new Accuracy(totalWeight, totalPositiveWeight);
            }
            case 3: {
                return new Bias(totalWeight, totalPositiveWeight);
            }
            case 4: {
                return new Lift(totalWeight, totalPositiveWeight);
            }
            case 5: {
                return new Binomial(totalWeight, totalPositiveWeight);
            }
            case 6: {
                return new WRAcc(totalWeight, totalPositiveWeight);
            }
            case 7: {
                return new Squared(totalWeight, totalPositiveWeight);
            }
            case 8: {
                return new Odds(totalWeight, totalPositiveWeight);
            }
            case 9: {
                return new OddsRatio(totalWeight, totalPositiveWeight);
            }
        }
        return new Coverage(totalWeight, totalPositiveWeight);
    }

    public static Class<? extends UtilityFunction> getUtilityFunctionClass(int utilityFunctionIndex) {
        switch (utilityFunctionIndex) {
            case 0: {
                return Coverage.class;
            }
            case 1: {
                return Precision.class;
            }
            case 2: {
                return Accuracy.class;
            }
            case 3: {
                return Bias.class;
            }
            case 4: {
                return Lift.class;
            }
            case 5: {
                return Binomial.class;
            }
            case 6: {
                return WRAcc.class;
            }
            case 7: {
                return Squared.class;
            }
            case 8: {
                return Odds.class;
            }
            case 9: {
                return OddsRatio.class;
            }
        }
        return null;
    }

    public static UtilityFunction[] getUtilityFunctions(double totalWeight, double totalPositiveWeight) {
        UtilityFunction[] utilities = new UtilityFunction[FUNCTIONS.length];
        int i = 0;
        while (i < FUNCTIONS.length) {
            utilities[i] = UtilityFunction.getUtilityFunction(i, totalWeight, totalPositiveWeight);
            ++i;
        }
        return utilities;
    }

    public static Class[] getUtilityFunctionClasses() {
        Class[] utilityFunctionClasses = new Class[FUNCTIONS.length];
        int i = 0;
        while (i < FUNCTIONS.length) {
            utilityFunctionClasses[i] = UtilityFunction.getUtilityFunctionClass(i);
            ++i;
        }
        return utilityFunctionClasses;
    }

    public String toString() {
        return this.getName();
    }
}

