/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.learner.tree.Criterion;
import com.rapidminer.operator.learner.tree.FrequencyCalculator;

public abstract class AbstractCriterion
implements Criterion {
    protected double leftWeight;
    protected double rightWeight;
    protected double totalWeight;
    protected double[] totalLabelWeights;
    protected double[] leftLabelWeights;
    protected double[] rightLabelWeights;
    protected Attribute labelAttribute;
    protected Attribute weightAttribute;

    public boolean supportsIncrementalCalculation() {
        return false;
    }

    public void startIncrementalCalculation(ExampleSet exampleSet) {
        FrequencyCalculator calculator = new FrequencyCalculator();
        this.rightLabelWeights = calculator.getLabelWeights(exampleSet);
        this.leftLabelWeights = new double[this.rightLabelWeights.length];
        this.totalLabelWeights = new double[this.rightLabelWeights.length];
        System.arraycopy(this.rightLabelWeights, 0, this.totalLabelWeights, 0, this.rightLabelWeights.length);
        this.leftWeight = 0.0;
        this.totalWeight = this.rightWeight = calculator.getTotalWeight(this.totalLabelWeights);
        this.labelAttribute = exampleSet.getAttributes().getLabel();
        this.weightAttribute = exampleSet.getAttributes().getWeight();
    }

    public void swapExample(Example example) {
        double weight = 1.0;
        if (this.weightAttribute != null) {
            weight = example.getValue(this.weightAttribute);
        }
        int label = (int)example.getValue(this.labelAttribute);
        this.leftWeight += weight;
        this.rightWeight -= weight;
        int n = label;
        this.leftLabelWeights[n] = this.leftLabelWeights[n] + weight;
        int n2 = label;
        this.rightLabelWeights[n2] = this.rightLabelWeights[n2] - weight;
    }

    public double getIncrementalBenefit() {
        return 0.0;
    }
}

