/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.operator.learner.SimplePredictionModel;
import com.rapidminer.operator.learner.meta.SimpleVoteModel;
import com.rapidminer.operator.learner.tree.RandomTreeLearner;
import com.rapidminer.operator.learner.tree.TreeModel;
import com.rapidminer.operator.preprocessing.sampling.Bootstrapping;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.OperatorService;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomForestLearner
extends AbstractLearner {
    public static final String PARAMETER_NUMBER_OF_TREES = "number_of_trees";

    public RandomForestLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        RandomTreeLearner randomTreeLearner = null;
        try {
            randomTreeLearner = OperatorService.createOperator(RandomTreeLearner.class);
            List<ParameterType> parameters = randomTreeLearner.getParameterTypes();
            for (ParameterType parameter : parameters) {
                String value = this.getParameter(parameter.getKey());
                if (value == null) continue;
                randomTreeLearner.setParameter(parameter.getKey(), value.toString());
            }
        }
        catch (OperatorCreationException e) {
            throw new OperatorException(String.valueOf(this.getName()) + ": cannot construct random tree learner: " + e.getMessage());
        }
        Bootstrapping bootstrapping = null;
        try {
            bootstrapping = OperatorService.createOperator(Bootstrapping.class);
            bootstrapping.setParameter("sample_ratio", "1.0");
        }
        catch (OperatorCreationException e) {
            throw new OperatorException(String.valueOf(this.getName()) + ": cannot construct random tree learner: " + e.getMessage());
        }
        LinkedList<SimplePredictionModel> baseModels = new LinkedList<SimplePredictionModel>();
        int numberOfTrees = this.getParameterAsInt(PARAMETER_NUMBER_OF_TREES);
        int i = 0;
        while (i < numberOfTrees) {
            TreeModel model = (TreeModel)randomTreeLearner.learn((ExampleSet)exampleSet.clone());
            baseModels.add(model);
            ++i;
        }
        return new SimpleVoteModel(exampleSet, baseModels);
    }

    @Override
    public boolean supportsCapability(LearnerCapability capability) {
        if (capability == LearnerCapability.BINOMINAL_ATTRIBUTES) {
            return true;
        }
        if (capability == LearnerCapability.POLYNOMINAL_ATTRIBUTES) {
            return true;
        }
        if (capability == LearnerCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        if (capability == LearnerCapability.POLYNOMINAL_CLASS) {
            return true;
        }
        if (capability == LearnerCapability.BINOMINAL_CLASS) {
            return true;
        }
        return capability == LearnerCapability.WEIGHTED_EXAMPLES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_OF_TREES, "The number of learned random trees.", 1, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        try {
            RandomTreeLearner randomTreeLearner = OperatorService.createOperator(RandomTreeLearner.class);
            List<ParameterType> innerParameters = ((Operator)randomTreeLearner).getParameterTypes();
            for (ParameterType innerType : innerParameters) {
                if (innerType.getKey().equals("no_pruning")) {
                    innerType.setDefaultValue(false);
                    continue;
                }
                if (innerType.getKey().equals("confidence") || innerType.getKey().equals("keep_example_set")) continue;
                types.add(innerType);
            }
        }
        catch (OperatorCreationException e) {
            this.logWarning("Cannot create random tree learner: " + e.getMessage());
        }
        return types;
    }
}

