/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta.branch;

import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.SimpleChainInnerOperatorCondition;
import com.rapidminer.operator.meta.branch.AttributeAvailableCondition;
import com.rapidminer.operator.meta.branch.DataValueCondition;
import com.rapidminer.operator.meta.branch.FileExistsCondition;
import com.rapidminer.operator.meta.branch.InputExistsCondition;
import com.rapidminer.operator.meta.branch.MaxFitnessCondition;
import com.rapidminer.operator.meta.branch.MaxNumberOfAttributesCondition;
import com.rapidminer.operator.meta.branch.MaxNumberOfExamplesCondition;
import com.rapidminer.operator.meta.branch.MaxPerformanceValueCondition;
import com.rapidminer.operator.meta.branch.MinFitnessCondition;
import com.rapidminer.operator.meta.branch.MinNumberOfAttributesCondition;
import com.rapidminer.operator.meta.branch.MinNumberOfExamplesCondition;
import com.rapidminer.operator.meta.branch.MinPerformanceValueCondition;
import com.rapidminer.operator.meta.branch.ProcessBranchCondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualStringCondition;
import com.rapidminer.parameter.conditions.NonEqualStringCondition;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.Tools;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessBranch
extends OperatorChain {
    public static final String PARAMETER_CONDITION_TYPE = "condition_type";
    public static final String PARAMETER_CONDITION_VALUE = "condition_value";
    public static final String PARAMETER_RETURN_INNER_OUTPUT = "return_inner_output";
    public static final String PARAMETER_IO_OBJECT = "io_object";
    public static final String[] CONDITION_NAMES = new String[]{"attribute_value_filter", "attribute_available", "min_examples", "max_examples", "min_attributes", "max_attributes", "min_fitness", "max_fitness", "min_performance_value", "max_performance_value", "file_exists", "input_exists"};
    public static final Class[] CONDITION_CLASSES = new Class[]{DataValueCondition.class, AttributeAvailableCondition.class, MinNumberOfExamplesCondition.class, MaxNumberOfExamplesCondition.class, MinNumberOfAttributesCondition.class, MaxNumberOfAttributesCondition.class, MinFitnessCondition.class, MaxFitnessCondition.class, MinPerformanceValueCondition.class, MaxPerformanceValueCondition.class, FileExistsCondition.class, InputExistsCondition.class};
    public static final String CONDITION_INPUT_EXISTS = CONDITION_NAMES[CONDITION_NAMES.length - 1];
    private String[] objectArray = null;

    public ProcessBranch(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        IOContainer input = this.getInput();
        Class conditionClass = null;
        String selectedConditionName = "";
        selectedConditionName = this.getParameterAsString(PARAMETER_CONDITION_TYPE);
        int i = 0;
        while (i < CONDITION_NAMES.length) {
            if (selectedConditionName.toLowerCase().equals(CONDITION_NAMES[i].toLowerCase())) {
                conditionClass = CONDITION_CLASSES[i];
                break;
            }
            ++i;
        }
        if (conditionClass == null) {
            try {
                conditionClass = Tools.classForName(selectedConditionName);
            }
            catch (ClassNotFoundException e) {
                throw new UserError((Operator)this, (Throwable)e, 904, selectedConditionName, e);
            }
        }
        ProcessBranchCondition condition = null;
        try {
            condition = (ProcessBranchCondition)conditionClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new UserError((Operator)this, (Throwable)e, 904, selectedConditionName, e);
        }
        catch (IllegalAccessException e) {
            throw new UserError((Operator)this, (Throwable)e, 904, selectedConditionName, e);
        }
        IOObject[] innerResults = null;
        if (condition != null) {
            String conditionValue = null;
            if (CONDITION_INPUT_EXISTS.equals(selectedConditionName)) {
                Class<IOObject> selectedConditionClass = this.getSelectedClass();
                if (selectedConditionClass == null) {
                    throw new UserError((Operator)this, 904, "'" + this.getParameter(PARAMETER_IO_OBJECT) + "'", "Class does not exist.");
                }
                conditionValue = null;
            } else {
                conditionValue = this.getParameterAsString(PARAMETER_CONDITION_VALUE);
            }
            boolean conditionState = condition.check(this, conditionValue);
            innerResults = conditionState ? this.getOperator(0).apply(input).getIOObjects() : (this.getNumberOfOperators() > 1 ? this.getOperator(1).apply(input).getIOObjects() : new IOObject[]{});
        } else {
            innerResults = new IOObject[]{};
            return innerResults;
        }
        if (this.getParameterAsBoolean(PARAMETER_RETURN_INNER_OUTPUT)) {
            if (innerResults != null) {
                return innerResults;
            }
            return new IOObject[0];
        }
        return new IOObject[0];
    }

    @Override
    public boolean getAddOnlyAdditionalOutput() {
        return this.getParameterAsBoolean(PARAMETER_RETURN_INNER_OUTPUT);
    }

    public <T extends IOObject> T getConditionInput(Class<T> cls) throws MissingIOObjectException {
        return this.getInput().get(cls);
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new SimpleChainInnerOperatorCondition();
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return 2;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    public Class<IOObject> getSelectedClass() throws UndefinedParameterError {
        int ioType = this.getParameterAsInt(PARAMETER_IO_OBJECT);
        if (ioType >= 0 && ioType < this.objectArray.length) {
            if (this.objectArray != null) {
                return OperatorService.getIOObjectClass(this.objectArray[ioType]);
            }
            return null;
        }
        return null;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeStringCategory(PARAMETER_CONDITION_TYPE, "The condition which is used for the condition check.", CONDITION_NAMES));
        ParameterTypeSingle type = new ParameterTypeString(PARAMETER_CONDITION_VALUE, "A condition parameter which might be desired for some condition checks.", true);
        type.registerDependencyCondition(new NonEqualStringCondition(this, PARAMETER_CONDITION_TYPE, true, CONDITION_INPUT_EXISTS));
        types.add(type);
        Set<String> ioObjects = OperatorService.getIOObjectsNames();
        this.objectArray = new String[ioObjects.size()];
        Iterator<String> i = ioObjects.iterator();
        int index = 0;
        while (i.hasNext()) {
            this.objectArray[index++] = i.next();
        }
        type = new ParameterTypeCategory(PARAMETER_IO_OBJECT, "The class of the object(s) which should be checked for existance.", this.objectArray, 0);
        type.registerDependencyCondition(new EqualStringCondition(this, PARAMETER_CONDITION_TYPE, true, CONDITION_INPUT_EXISTS));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_RETURN_INNER_OUTPUT, "Indicates if the output of the inner operators should be delivered.", true));
        return types;
    }
}

