/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.AbstractPerformanceEvaluator;
import com.rapidminer.operator.performance.ForecastingCriterion;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PredictionTrendAccuracy;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForecastingPerformanceEvaluator
extends AbstractPerformanceEvaluator {
    public static final String PARAMETER_HORIZON = "horizon";
    private static final Class[] SIMPLE_CRITERIA_CLASSES = new Class[]{PredictionTrendAccuracy.class};

    public ForecastingPerformanceEvaluator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected void checkCompatibility(ExampleSet exampleSet) throws OperatorException {
        Tools.isLabelled(exampleSet);
        Tools.isNonEmpty(exampleSet);
    }

    @Override
    protected double[] getClassWeights(Attribute label) throws UndefinedParameterError {
        return null;
    }

    @Override
    public List<PerformanceCriterion> getCriteria() {
        LinkedList<PerformanceCriterion> allCriteria = new LinkedList<PerformanceCriterion>();
        int i = 0;
        while (i < SIMPLE_CRITERIA_CLASSES.length) {
            try {
                PerformanceCriterion criterion = (PerformanceCriterion)SIMPLE_CRITERIA_CLASSES[i].newInstance();
                ((ForecastingCriterion)((Object)criterion)).setParent(this);
                allCriteria.add(criterion);
            }
            catch (InstantiationException e) {
                LogService.getGlobal().logError("Cannot instantiate " + SIMPLE_CRITERIA_CLASSES[i] + ". Skipping...");
            }
            catch (IllegalAccessException e) {
                LogService.getGlobal().logError("Cannot instantiate " + SIMPLE_CRITERIA_CLASSES[i] + ". Skipping...");
            }
            ++i;
        }
        return allCriteria;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeInt(PARAMETER_HORIZON, "Indicates the horizon for the calculation of the forecasting performance measures.", 1, Integer.MAX_VALUE, false));
        types.addAll(super.getParameterTypes());
        return types;
    }
}

