/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.tools.math.Averagable;
import java.util.Iterator;

public class SoftMarginLoss
extends MeasuredPerformance {
    private static final long serialVersionUID = -2987795640706342168L;
    private double margin = Double.NaN;
    private double counter = 1.0;

    public SoftMarginLoss() {
    }

    public SoftMarginLoss(SoftMarginLoss m) {
        super(m);
        this.margin = m.margin;
        this.counter = m.counter;
    }

    public void startCounting(ExampleSet exampleSet, boolean useExampleWeights) throws OperatorException {
        super.startCounting(exampleSet, useExampleWeights);
        Iterator reader = exampleSet.iterator();
        this.margin = 0.0;
        this.counter = 0.0;
        Attribute labelAttr = exampleSet.getAttributes().getLabel();
        Attribute weightAttribute = null;
        if (useExampleWeights) {
            weightAttribute = exampleSet.getAttributes().getWeight();
        }
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            String trueLabel = example.getNominalValue(labelAttr);
            double confidence = example.getConfidence(trueLabel);
            double currentMargin = Math.max(0.0, 1.0 - confidence);
            double weight = 1.0;
            if (weightAttribute != null) {
                weight = example.getValue(weightAttribute);
            }
            this.margin += currentMargin * weight;
            this.counter += weight;
        }
    }

    public void countExample(Example example) {
    }

    public double getExampleCount() {
        return this.counter;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public double getMikroAverage() {
        return this.margin / this.counter;
    }

    public double getMaxFitness() {
        return 0.0;
    }

    public double getFitness() {
        return -1.0 * this.getAverage();
    }

    public String getName() {
        return "soft_margin_loss";
    }

    public String getDescription() {
        return "The average soft margin loss of a classifier, defined as the average of all 1 - confidences for the correct label.";
    }

    public void buildSingleAverage(Averagable performance) {
        SoftMarginLoss other = (SoftMarginLoss)performance;
        this.counter += other.counter;
        this.margin += other.margin;
    }

    public String toString() {
        return super.toString();
    }
}

