/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PreprocessingOperator
extends Operator {
    public static final String PARAMETER_RETURN_PREPROCESSING_MODEL = "return_preprocessing_model";
    public static final String PARAMETER_CREATE_VIEW = "create_view";

    public PreprocessingOperator(OperatorDescription description) {
        super(description);
    }

    public abstract Model createPreprocessingModel(ExampleSet var1) throws OperatorException;

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Model model = this.createPreprocessingModel(exampleSet);
        model.setParameter(PARAMETER_CREATE_VIEW, this.getParameterAsBoolean(PARAMETER_CREATE_VIEW));
        exampleSet = model.apply(exampleSet);
        if (this.getParameterAsBoolean(PARAMETER_RETURN_PREPROCESSING_MODEL)) {
            return new IOObject[]{exampleSet, model};
        }
        return new IOObject[]{exampleSet};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        if (this.getParameterAsBoolean(PARAMETER_RETURN_PREPROCESSING_MODEL)) {
            return new Class[]{ExampleSet.class, Model.class};
        }
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_RETURN_PREPROCESSING_MODEL, "Indicates if the preprocessing model should also be returned", false));
        types.add(new ParameterTypeBoolean(PARAMETER_CREATE_VIEW, "Create View to apply preprocessing instead of changing the data", false));
        return types;
    }
}

