/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeAttributeRoles
extends AbstractDataProcessing {
    public static final String PARAMETER_FIRST_ATTRIBUTE = "first_attribute";
    public static final String PARAMETER_SECOND_ATTRIBUTE = "second_attribute";

    public ExchangeAttributeRoles(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String firstName = this.getParameterAsString(PARAMETER_FIRST_ATTRIBUTE);
        String secondName = this.getParameterAsString(PARAMETER_SECOND_ATTRIBUTE);
        AttributeRole firstRole = exampleSet.getAttributes().getRole(firstName);
        AttributeRole secondRole = exampleSet.getAttributes().getRole(secondName);
        if (firstRole == null) {
            throw new UserError((Operator)this, 111, firstName);
        }
        if (secondRole == null) {
            throw new UserError((Operator)this, 111, secondName);
        }
        String firstRoleName = firstRole.getSpecialName();
        String secondRoleName = secondRole.getSpecialName();
        firstRole.changeToRegular();
        secondRole.changeToRegular();
        firstRole.setSpecial(secondRoleName);
        secondRole.setSpecial(firstRoleName);
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_FIRST_ATTRIBUTE, "The name of the first attribute for the attribute role exchange.", false));
        types.add(new ParameterTypeString(PARAMETER_SECOND_ATTRIBUTE, "The name of the first attribute for the attribute role exchange.", false));
        return types;
    }
}

