/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.SimpleAttributes;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.ViewAttribute;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.operator.preprocessing.PreprocessingOperator;
import java.util.Iterator;
import java.util.LinkedList;

public class NominalToNumeric
extends PreprocessingOperator {
    public NominalToNumeric(OperatorDescription description) {
        super(description);
    }

    public Model createPreprocessingModel(ExampleSet exampleSet) throws OperatorException {
        return new NominalToNumericModel(exampleSet);
    }

    private static class NominalToNumericModel
    extends PreprocessingModel {
        private static final long serialVersionUID = -4203775081616082145L;

        protected NominalToNumericModel(ExampleSet exampleSet) {
            super(exampleSet);
        }

        public ExampleSet applyOnData(ExampleSet exampleSet) throws OperatorException {
            LinkedList<Attribute> nominalAttributes = new LinkedList<Attribute>();
            LinkedList<Attribute> transformedAttributes = new LinkedList<Attribute>();
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (attribute.isNumerical()) continue;
                nominalAttributes.add(attribute);
                transformedAttributes.add(AttributeFactory.createAttribute(attribute.getName(), 2));
            }
            exampleSet.getExampleTable().addAttributes(transformedAttributes);
            for (Example example : exampleSet) {
                Iterator target = transformedAttributes.iterator();
                for (Attribute attribute : nominalAttributes) {
                    example.setValue((Attribute)target.next(), example.getValue(attribute));
                }
            }
            Attributes attributes = exampleSet.getAttributes();
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (attribute.isNumerical()) continue;
                attributes.replace(attribute, transformedAttributes.poll());
            }
            return exampleSet;
        }

        public Attributes getTargetAttributes(ExampleSet parentSet) {
            SimpleAttributes attributes = new SimpleAttributes();
            Iterator<AttributeRole> specialRoles = parentSet.getAttributes().specialAttributes();
            while (specialRoles.hasNext()) {
                attributes.add(specialRoles.next());
            }
            Iterator<AttributeRole> i = parentSet.getAttributes().allAttributeRoles();
            while (i.hasNext()) {
                AttributeRole attributeRole = i.next();
                if (attributeRole.isSpecial()) continue;
                Attribute attribute = attributeRole.getAttribute();
                if (!attribute.isNumerical()) {
                    attributes.addRegular(new ViewAttribute(this, attribute, attribute.getName(), 3, null));
                    continue;
                }
                attributes.add(attributeRole);
            }
            return attributes;
        }

        public double getValue(Attribute targetAttribute, double value) {
            return value;
        }
    }
}

