/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowReader;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermutationOperator
extends AbstractDataProcessing {
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";

    public PermutationOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        ExampleTable table = exampleSet.getExampleTable();
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            attributeList.add((Attribute)attribute.clone());
        }
        int toCopy = table.size();
        MemoryExampleTable shuffledTable = new MemoryExampleTable(attributeList);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        DataRow[] isCopied = new DataRow[toCopy];
        int areCopied = 0;
        DataRowReader reader = table.getDataRowReader();
        while (areCopied < toCopy) {
            int currentRow = (int)Math.round(random.nextDouble() * (double)(toCopy - 1));
            if (isCopied[currentRow] == null) {
                isCopied[currentRow] = (DataRow)reader.next();
                ++areCopied;
            }
            this.checkForStop();
        }
        int i = 0;
        while (i < toCopy) {
            shuffledTable.addDataRow(isCopied[i]);
            ++i;
        }
        return shuffledTable.createExampleSet(exampleSet.getAttributes().specialAttributes());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global)", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

