/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.outlier;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.outlier.AbstractOutlierDetection;
import com.rapidminer.operator.preprocessing.outlier.SearchObject;
import com.rapidminer.operator.preprocessing.outlier.SearchSpace;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DKNOutlierOperator
extends AbstractOutlierDetection {
    public static final String PARAMETER_NUMBER_OF_NEIGHBORS = "number_of_neighbors";
    public static final String PARAMETER_NUMBER_OF_OUTLIERS = "number_of_outliers";
    public static final String PARAMETER_DISTANCE_FUNCTION = "distance_function";
    private static final String[] distanceFunctionList = new String[]{"euclidian distance", "squared distance", "cosine distance", "inverted cosine distance", "angle"};

    public DKNOutlierOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet eSet) throws OperatorException {
        int k = this.getParameterAsInt(PARAMETER_NUMBER_OF_NEIGHBORS);
        int n = this.getParameterAsInt(PARAMETER_NUMBER_OF_OUTLIERS);
        n -= 2;
        int kindOfDistance = this.getParameterAsInt(PARAMETER_DISTANCE_FUNCTION);
        Iterator reader = eSet.iterator();
        int searchSpaceDimension = eSet.getAttributes().size();
        SearchSpace sr = new SearchSpace(searchSpaceDimension, k, k);
        int counter = 0;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            SearchObject so = new SearchObject(searchSpaceDimension, "object" + counter, k, k + 1);
            ++counter;
            int i = 0;
            for (Attribute attribute : eSet.getAttributes()) {
                so.setVektor(i++, example.getValue(attribute));
            }
            sr.addObject(so);
        }
        this.log("Searching d=" + sr.getDimensions() + " dimensions with k=" + k + " and n=" + n);
        sr.resetOutlierStatus();
        sr.findAllKdContainers(kindOfDistance);
        sr.computeDKN(k, n);
        Attribute outlierAttribute = AttributeFactory.createAttribute("Outlier", 6);
        outlierAttribute.getMapping().mapString("false");
        outlierAttribute.getMapping().mapString("true");
        eSet.getExampleTable().addAttribute(outlierAttribute);
        eSet.getAttributes().setOutlier(outlierAttribute);
        counter = 0;
        for (Example example : eSet) {
            if (sr.getSearchObjectOutlierStatus(counter)) {
                example.setValue(outlierAttribute, outlierAttribute.getMapping().mapString("true"));
            } else {
                example.setValue(outlierAttribute, outlierAttribute.getMapping().mapString("false"));
            }
            ++counter;
        }
        return eSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_NUMBER_OF_NEIGHBORS, "Specifies the k value for the k-th nearest neighbours to be the analyzed.(default value is 10, minimum 1 and max is set to 1 million)", 1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeInt(PARAMETER_NUMBER_OF_OUTLIERS, "The number of top-n Outliers to be looked for.(default value is 10, minimum 2 (internal reasons) and max is set to 1 million)", 1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeCategory(PARAMETER_DISTANCE_FUNCTION, "choose which distance function will be used for calculating the distance between two objects", distanceFunctionList, 0));
        return types;
    }
}

