/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.series;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.series.AbstractSeriesProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowExamples2ModelingData
extends AbstractSeriesProcessing {
    public static final String PARAMETER_LABEL_NAME_STEM = "label_name_stem";
    public static final String PARAMETER_HORIZON = "horizon";
    public static final String PARAMETER_RELATIVE_TRANSFORMATION = "relative_transformation";

    public WindowExamples2ModelingData(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String labelName = this.getParameterAsString(PARAMETER_LABEL_NAME_STEM);
        int horizon = this.getParameterAsInt(PARAMETER_HORIZON);
        Attribute labelAttribute = null;
        LinkedList<String> baseNames = new LinkedList<String>();
        LinkedList<Attribute> toRemove = new LinkedList<Attribute>();
        int windowWidth = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (attribute.getName().endsWith("-0")) {
                String baseName = attribute.getName().substring(0, attribute.getName().lastIndexOf("-"));
                baseNames.add(baseName);
                if (attribute.getName().startsWith(labelName)) {
                    labelAttribute = attribute;
                }
            }
            int index = Integer.valueOf(attribute.getName().substring(attribute.getName().lastIndexOf("-") + 1));
            windowWidth = Math.max(windowWidth, index);
            if (index < 0 || index >= horizon) continue;
            toRemove.add(attribute);
        }
        if (labelAttribute == null) {
            throw new UserError((Operator)this, 111, String.valueOf(labelName) + "-0");
        }
        if (windowWidth < horizon) {
            throw new UserError((Operator)this, 207, horizon, PARAMETER_HORIZON, "the horizon has to be larger than the window width");
        }
        for (Attribute attribute : toRemove) {
            exampleSet.getAttributes().remove(attribute);
        }
        exampleSet.getAttributes().setLabel(labelAttribute);
        if (this.getParameterAsBoolean(PARAMETER_RELATIVE_TRANSFORMATION) && labelAttribute.isNumerical()) {
            Attribute baseValueAttribute = AttributeFactory.createAttribute("base_value", 4);
            exampleSet.getExampleTable().addAttribute(baseValueAttribute);
            exampleSet.getAttributes().setSpecialAttribute(baseValueAttribute, "base_value");
            for (Example example : exampleSet) {
                String lastKnownLabelName = String.valueOf(labelName) + "-" + horizon;
                Attribute lastKnownLabelAttribute = exampleSet.getAttributes().get(lastKnownLabelName);
                double baseLabelValue = example.getValue(lastKnownLabelAttribute);
                example.setValue(baseValueAttribute, baseLabelValue);
                for (String baseName : baseNames) {
                    String lastKnownBaseName = String.valueOf(baseName) + "-" + horizon;
                    Attribute lastKnownBaseAttribute = exampleSet.getAttributes().get(lastKnownBaseName);
                    double baseAttributeValue = example.getValue(lastKnownBaseAttribute);
                    int w = horizon;
                    while (w <= windowWidth) {
                        String currentName = String.valueOf(baseName) + "-" + w;
                        Attribute currentAttribute = exampleSet.getAttributes().get(currentName);
                        double currentValue = example.getValue(currentAttribute);
                        example.setValue(currentAttribute, currentValue - baseAttributeValue);
                        ++w;
                    }
                }
                example.setValue(labelAttribute, example.getValue(labelAttribute) - baseLabelValue);
            }
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_LABEL_NAME_STEM, "The name stem of the label attribute.", false));
        types.add(new ParameterTypeInt(PARAMETER_HORIZON, "The horizon for the prediction.", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeBoolean(PARAMETER_RELATIVE_TRANSFORMATION, "Indicates if a relative transformation of value should be performed", true));
        return types;
    }
}

