/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.series.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LagSeries
extends Operator {
    public static final String PARAMETER_ATTRIBUTES = "attributes";
    public static final String PARAMETER_LAG = "lag";

    public LagSeries(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        List<String[]> list = this.getParameterList(PARAMETER_ATTRIBUTES);
        String[] attributeNames = new String[list.size()];
        Attribute[] origAttributes = new Attribute[list.size()];
        Attribute[] laggedAttributes = new Attribute[list.size()];
        double[][] valueBuffer = new double[list.size()][];
        int[] valueBufferIndex = new int[list.size()];
        int[] lags = new int[list.size()];
        Iterator<String[]> listIterator = list.iterator();
        int i = 0;
        while (listIterator.hasNext()) {
            Object[] pair = listIterator.next();
            attributeNames[i] = (String)pair[0];
            lags[i] = Integer.parseInt((String)pair[1]) - 1;
            valueBuffer[i] = new double[lags[i] + 1];
            valueBufferIndex[i] = 0;
            int j = 0;
            while (j < valueBuffer[i].length) {
                valueBuffer[i][j] = Double.NaN;
                ++j;
            }
            origAttributes[i] = exampleSet.getAttributes().get(attributeNames[i]);
            laggedAttributes[i] = AttributeFactory.createAttribute(String.valueOf(origAttributes[i].getName()) + "-" + (lags[i] + 1), origAttributes[i].getValueType());
            exampleSet.getExampleTable().addAttribute(laggedAttributes[i]);
            exampleSet.getAttributes().addRegular(laggedAttributes[i]);
            ++i;
        }
        for (Example example : exampleSet) {
            int j = 0;
            while (j < laggedAttributes.length) {
                example.setValue(laggedAttributes[j], valueBuffer[j][valueBufferIndex[j]]);
                valueBuffer[j][valueBufferIndex[j]] = example.getValue(origAttributes[j]);
                valueBufferIndex[j] = valueBufferIndex[j] == lags[j] ? 0 : valueBufferIndex[j] + 1;
                ++j;
            }
        }
        return new IOObject[]{exampleSet};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt lag = new ParameterTypeInt(PARAMETER_LAG, "The lag for the specified attribute.", 1, Integer.MAX_VALUE);
        types.add(new ParameterTypeList(PARAMETER_ATTRIBUTES, "The attributes which should be lagged.", lag));
        return types;
    }
}

