/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.transformation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.transformation.ExampleSetTransformationOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute2ExamplePivoting
extends ExampleSetTransformationOperator {
    public static final String PARAMETER_ATTRIBUTE_NAME_REGEX = "attributes";
    public static final String PARAMETER_SERIES = "attribute_name";
    public static final String PARAMETER_INDEX_ATTRIBUTE = "index_attribute";
    public static final String PARAMETER_KEEP_MISSINGS = "keep_missings";
    public static final String PARAMETER_CREATE_NOMINAL_INDEX = "create_nominal_index";

    public Attribute2ExamplePivoting(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        List<String[]> seriesList = this.getParameterList(PARAMETER_SERIES);
        int numberOfSeries = seriesList.size();
        boolean createNominalIndex = this.getParameterAsBoolean(PARAMETER_CREATE_NOMINAL_INDEX);
        if (numberOfSeries > 1 && createNominalIndex) {
            throw new UserError((Operator)this, 207, "true", PARAMETER_CREATE_NOMINAL_INDEX, "More than one series listed in attribute names");
        }
        String[] seriesNames = new String[numberOfSeries];
        Pattern[] seriesPatterns = new Pattern[numberOfSeries];
        ArrayList seriesAttributes = new ArrayList(numberOfSeries);
        int[] attributeTypes = new int[numberOfSeries];
        Iterator<String[]> iterator = seriesList.iterator();
        int j = 0;
        while (iterator.hasNext()) {
            String[] pair = iterator.next();
            seriesNames[j] = pair[0];
            seriesPatterns[j] = Pattern.compile(pair[1]);
            seriesAttributes.add(j, new Vector());
            attributeTypes[j] = 0;
            ++j;
        }
        Vector<Attribute> newAttributes = new Vector<Attribute>();
        Vector<Attribute> constantAttributes = new Vector<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            boolean matched = false;
            int i = 0;
            while (i < numberOfSeries) {
                Matcher matcher = seriesPatterns[i].matcher(attribute.getName());
                if (matcher.matches()) {
                    matched = true;
                    ((Vector)seriesAttributes.get(i)).add(attribute);
                    if (attributeTypes[i] != 0) {
                        if (attribute.getValueType() == attributeTypes[i]) break;
                        throw new OperatorException("attributes have different value types: no conversion is performed");
                    }
                    attributeTypes[i] = attribute.getValueType();
                    break;
                }
                ++i;
            }
            if (matched) continue;
            Attribute attributeCopy = AttributeFactory.createAttribute(attribute.getName(), attribute.getValueType());
            if (attribute.isNominal()) {
                attributeCopy.setMapping((NominalMapping)attribute.getMapping().clone());
            }
            newAttributes.add(attributeCopy);
            constantAttributes.add(attribute);
        }
        int seriesLength = 0;
        if (numberOfSeries >= 1) {
            seriesLength = ((Vector)seriesAttributes.get(0)).size();
            int i = 0;
            while (i < numberOfSeries - 1) {
                seriesLength = ((Vector)seriesAttributes.get(i)).size();
                if (seriesLength != ((Vector)seriesAttributes.get(i + 1)).size()) {
                    throw new OperatorException("series must have the same length: no conversion is performed");
                }
                ++i;
            }
        }
        Attribute indexAttribute = !createNominalIndex ? AttributeFactory.createAttribute(this.getParameterAsString(PARAMETER_INDEX_ATTRIBUTE), 3) : AttributeFactory.createAttribute(this.getParameterAsString(PARAMETER_INDEX_ATTRIBUTE), 7);
        newAttributes.add(indexAttribute);
        int i = 0;
        while (i < numberOfSeries) {
            if (attributeTypes[i] == 0) {
                this.logError("Cannot create pivot attribute " + seriesNames[i] + ": No matching attributes found.");
            } else {
                Attribute seriesAttribute = AttributeFactory.createAttribute(seriesNames[i], attributeTypes[i]);
                newAttributes.add(seriesAttribute);
            }
            ++i;
        }
        MemoryExampleTable table = new MemoryExampleTable(newAttributes);
        for (Example example : exampleSet) {
            int l = 0;
            int k = 0;
            while (k < seriesLength) {
                ++l;
                double[] data = new double[newAttributes.size()];
                int i2 = 0;
                while (i2 < data.length) {
                    data[i2] = Double.NaN;
                    ++i2;
                }
                i2 = 0;
                while (i2 < constantAttributes.size()) {
                    data[i2] = example.getValue((Attribute)constantAttributes.get(i2));
                    ++i2;
                }
                data[data.length - numberOfSeries - 1] = !createNominalIndex ? (double)l : (double)indexAttribute.getMapping().mapString(((Attribute)((Vector)seriesAttributes.get(0)).get(k)).getName());
                boolean onlyMissings = true;
                int i3 = 0;
                while (i3 < numberOfSeries) {
                    Attribute seriesAttribute = (Attribute)((Vector)seriesAttributes.get(i3)).get(k);
                    double seriesValue = example.getValue(seriesAttribute);
                    double newValue = Double.NaN;
                    if (!Double.isNaN(seriesValue)) {
                        newValue = seriesAttribute.isNominal() ? (double)newAttributes.get(newAttributes.size() - numberOfSeries + i3).getMapping().mapString(seriesAttribute.getMapping().mapIndex((int)seriesValue)) : seriesValue;
                        onlyMissings = false;
                    }
                    data[data.length - numberOfSeries + i3] = newValue;
                    ++i3;
                }
                this.checkForStop();
                if (this.getParameterAsBoolean(PARAMETER_KEEP_MISSINGS) || !onlyMissings) {
                    table.addDataRow(new DoubleArrayDataRow(data));
                }
                ++k;
            }
        }
        ExampleSet result = table.createExampleSet();
        result.recalculateAllAttributeStatistics();
        return new IOObject[]{result};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeString attributeNames = new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME_REGEX, "Attributes that forms series.", false);
        ParameterType type = new ParameterTypeList(PARAMETER_SERIES, "Name of resulting attribute.", attributeNames);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeString(PARAMETER_INDEX_ATTRIBUTE, "Name of index attribute.", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_CREATE_NOMINAL_INDEX, "Indicates if the index attribute should contain the full attribute name. (Only works with one group)", false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_KEEP_MISSINGS, "Keep missing values.", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

