/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.similarity;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.similarity.SimilarityMeasure;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Similarity2ExampleSet
extends Operator {
    public static final String PARAMETER_TABLE_TYPE = "table_type";
    public static final String[] TABLE_TYPES = new String[]{"long_table", "matrix"};
    public static final int TABLE_TYPE_LONG_TABLE = 0;
    public static final int TABLE_TYPE_MATRIX = 1;

    public Similarity2ExampleSet(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        DistanceMeasure measure = this.getInput(SimilarityMeasure.class).getDistanceMeasure();
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Attribute id = exampleSet.getAttributes().getId();
        if (id == null) {
            throw new UserError(this, 129);
        }
        ExampleSet result = null;
        if (this.getParameterAsInt(PARAMETER_TABLE_TYPE) == 0) {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(3);
            Attribute firstIdAttribute = AttributeFactory.createAttribute("FIRST_ID", id.getValueType());
            attributes.add(firstIdAttribute);
            Attribute secondIdAttribute = AttributeFactory.createAttribute("SECOND_ID", id.getValueType());
            attributes.add(secondIdAttribute);
            String name = "SIMILARITY";
            if (measure.isDistance()) {
                name = "DISTANCE";
            }
            Attribute similarityAttribute = AttributeFactory.createAttribute(name, 4);
            attributes.add(similarityAttribute);
            MemoryExampleTable table = new MemoryExampleTable(attributes);
            int i = 0;
            for (Example example : exampleSet) {
                int j = 0;
                for (Example compExample : exampleSet) {
                    if (j != i) {
                        double[] data = new double[3];
                        if (id.isNominal()) {
                            data[0] = firstIdAttribute.getMapping().mapString(id.getMapping().mapIndex((int)example.getValue(id)));
                            data[1] = secondIdAttribute.getMapping().mapString(id.getMapping().mapIndex((int)compExample.getValue(id)));
                        } else {
                            data[0] = example.getValue(id);
                            data[1] = compExample.getValue(id);
                        }
                        data[2] = measure.isDistance() ? measure.calculateDistance(example, compExample) : measure.calculateSimilarity(example, compExample);
                        table.addDataRow(new DoubleArrayDataRow(data));
                    }
                    ++j;
                }
                ++i;
            }
            result = table.createExampleSet();
        } else {
            int numberOfExamples = exampleSet.size();
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(numberOfExamples + 1);
            Attribute newIdAttribute = AttributeFactory.createAttribute("ID", id.getValueType());
            attributes.add(newIdAttribute);
            for (Example example : exampleSet) {
                Attribute attribute = AttributeFactory.createAttribute(example.getValueAsString(id), 4);
                attributes.add(attribute);
            }
            MemoryExampleTable table = new MemoryExampleTable(attributes);
            for (Example example : exampleSet) {
                double[] data = new double[numberOfExamples + 1];
                data[0] = id.isNominal() ? (double)newIdAttribute.getMapping().mapString(id.getMapping().mapIndex((int)example.getValue(id))) : example.getValue(id);
                int index = 1;
                for (Example compExample : exampleSet) {
                    data[index++] = measure.isDistance() ? measure.calculateDistance(example, compExample) : measure.calculateSimilarity(example, compExample);
                }
                table.addDataRow(new DoubleArrayDataRow(data));
            }
            result = table.createExampleSet(null, null, newIdAttribute);
        }
        return new IOObject[]{result};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{SimilarityMeasure.class, ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_TABLE_TYPE, "Indicates if the resulting table should have a matrix format or a long table format.", TABLE_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

