/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.gui.viewer.ROCChartPlotter;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.report.Renderable;
import com.rapidminer.tools.math.ROCData;
import java.awt.Component;
import java.awt.Graphics;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROCComparison
extends ResultObjectAdapter
implements Renderable {
    private static final long serialVersionUID = 9181453276271041294L;
    private Map<String, List<ROCData>> rocData;
    private transient ROCChartPlotter plotter;

    public ROCComparison(Map<String, List<ROCData>> rocData) {
        this.rocData = rocData;
    }

    @Override
    public String getName() {
        return "ROC Comparison";
    }

    public String toString() {
        return "A comparison visualization based on the ROC plots for different classification schemes.";
    }

    @Override
    public String getExtension() {
        return "roc";
    }

    @Override
    public String getFileDescription() {
        return "ROC comparison files";
    }

    @Override
    public Component getVisualizationComponent(IOContainer container) {
        this.plotter = new ROCChartPlotter();
        for (Map.Entry<String, List<ROCData>> entry : this.rocData.entrySet()) {
            this.plotter.addROCData(entry.getKey(), entry.getValue());
        }
        return this.plotter;
    }

    @Override
    public void prepareRendering() {
        if (this.plotter == null) {
            this.getVisualizationComponent(null);
        }
        this.plotter.prepareRendering();
    }

    @Override
    public void finishRendering() {
        this.plotter.finishRendering();
        this.plotter = null;
    }

    @Override
    public int getRenderHeight(int preferredHeight) {
        return this.plotter.getRenderHeight(preferredHeight);
    }

    @Override
    public int getRenderWidth(int preferredWidth) {
        return this.plotter.getRenderWidth(preferredWidth);
    }

    @Override
    public void render(Graphics graphics, int width, int height) {
        this.plotter.render(graphics, width, height);
    }
}

