/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.visualization.dependencies.NumericalMatrix;
import com.rapidminer.tools.math.matrix.CovarianceMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CovarianceMatrixOperator
extends Operator {
    public CovarianceMatrixOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        String[] columnNames = new String[exampleSet.getAttributes().size()];
        int counter = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            columnNames[counter++] = attribute.getName();
        }
        Matrix covarianceMatrix = CovarianceMatrix.getCovarianceMatrix(exampleSet);
        return new IOObject[]{exampleSet, new NumericalMatrix("Covariance", columnNames, covarianceMatrix, true)};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class, NumericalMatrix.class};
    }
}

