/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.visualization.dependencies.RainflowMatrix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RainflowMatrixOperator
extends Operator {
    public static final String PARAMETER_ATTRIBUTE = "attribute";
    public static final String PARAMETER_SYMMETRICAL_MATRIX = "symmetrical_matrix";

    public RainflowMatrixOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        String attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE);
        Attribute attribute = exampleSet.getAttributes().get(attributeName);
        if (attribute == null) {
            throw new UserError((Operator)this, 111, attributeName);
        }
        if (!attribute.isNominal()) {
            throw new UserError((Operator)this, 103, "calculation of the Rainflow Matrix", attributeName);
        }
        ArrayList<String> values = new ArrayList<String>(exampleSet.size());
        for (Example example : exampleSet) {
            if (Double.isNaN(example.getValue(attribute))) continue;
            values.add(example.getNominalValue(attribute));
        }
        this.removeNonExtrema(values);
        LinkedList<String> allNames = new LinkedList<String>();
        for (String name : attribute.getMapping().getValues()) {
            allNames.add(name);
        }
        String[] columnNames = new String[allNames.size()];
        allNames.toArray(columnNames);
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        int i = 0;
        while (i < columnNames.length) {
            indexMap.put(columnNames[i], i);
            ++i;
        }
        double[][] counts = this.createRainflowCounts(values, indexMap);
        boolean symmetrical = this.getParameterAsBoolean(PARAMETER_SYMMETRICAL_MATRIX);
        if (symmetrical) {
            int x = 1;
            while (x < counts.length - 1) {
                int y = 1;
                while (y < counts[x].length - 1) {
                    double[] dArray = counts[y];
                    int n = x;
                    dArray[n] = dArray[n] + counts[x][y];
                    counts[x][y] = 0.0;
                    ++y;
                }
                ++x;
            }
        }
        Matrix matrix = new Matrix(counts);
        String[] residuals = new String[values.size()];
        values.toArray(residuals);
        RainflowMatrix rainflowMatrix = new RainflowMatrix("Rainflow Matrix", columnNames, matrix, symmetrical, residuals);
        rainflowMatrix.setFirstAttributeName("From Value");
        rainflowMatrix.setSecondAttributeName("To Value");
        return new IOObject[]{exampleSet, rainflowMatrix};
    }

    private double[][] createRainflowCounts(List<String> values, Map<String, Integer> indexMap) {
        double[][] counts = new double[indexMap.size()][indexMap.size()];
        int currentIndex = 4;
        while (currentIndex < values.size()) {
            boolean betweenDecreasing;
            String value1 = values.get(currentIndex - 4);
            String value2 = values.get(currentIndex - 3);
            String value3 = values.get(currentIndex - 2);
            String value4 = values.get(currentIndex - 1);
            boolean betweenIncreasing = value2.compareTo(value1) >= 0 && value2.compareTo(value4) <= 0 && value3.compareTo(value1) >= 0 && value3.compareTo(value4) <= 0;
            boolean bl = betweenDecreasing = value2.compareTo(value1) <= 0 && value2.compareTo(value4) >= 0 && value3.compareTo(value1) <= 0 && value3.compareTo(value4) >= 0;
            if (betweenIncreasing || betweenDecreasing) {
                int fromIndex = indexMap.get(value2);
                int toIndex = indexMap.get(value3);
                counts[fromIndex][toIndex] = counts[fromIndex][toIndex] + 1.0;
                values.remove(currentIndex - 2);
                values.remove(currentIndex - 3);
                currentIndex = 4;
                continue;
            }
            ++currentIndex;
        }
        return counts;
    }

    private void removeNonExtrema(List<String> values) {
        int i = values.size() - 2;
        while (i >= 1) {
            boolean localMaximum;
            String currentValue = values.get(i);
            String beforeValue = values.get(i - 1);
            String afterValue = values.get(i + 1);
            boolean localMinimum = beforeValue.compareTo(currentValue) > 0 && afterValue.compareTo(currentValue) > 0;
            boolean bl = localMaximum = beforeValue.compareTo(currentValue) < 0 && afterValue.compareTo(currentValue) < 0;
            if (!localMinimum && !localMaximum) {
                values.remove(i);
            }
            --i;
        }
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class, RainflowMatrix.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE, "Indicates which attribute should be used as a base for the calculation of the Rainflow matrix.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_SYMMETRICAL_MATRIX, "Indicates if the symmetrical matrix should be calculated.", false));
        return types;
    }
}

