/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.cipher.CipherException;
import com.rapidminer.tools.cipher.CipherTools;

public class ParameterTypePassword
extends ParameterTypeString {
    private static final long serialVersionUID = 384977559199162363L;

    public ParameterTypePassword(String key, String description) {
        super(key, description, true);
    }

    public String getRange() {
        return "password";
    }

    public String transformNewValue(String value) {
        return this.decryptPassword(value);
    }

    private String encryptPassword(String value) {
        if (CipherTools.isKeyAvailable()) {
            try {
                return CipherTools.encrypt(value);
            }
            catch (CipherException e) {
                LogService.getGlobal().logError("Cannot encrypt password, using non-encrypted password!");
                return value;
            }
        }
        return value;
    }

    private String decryptPassword(String value) {
        if (CipherTools.isKeyAvailable()) {
            try {
                return CipherTools.decrypt(value);
            }
            catch (CipherException e) {
                LogService.getGlobal().logWarning("Password in XML file looks like unencrypted plain text.");
            }
        }
        return value;
    }

    public String toString(Object value) {
        return this.encryptPassword(super.toString(value));
    }

    public String getXML(String indent, String key, String value, boolean hideDefault) {
        if (!(value == null || hideDefault && value.equals(this.getDefaultValue()))) {
            return String.valueOf(indent) + "<parameter key=\"" + key + "\"\tvalue=\"" + this.toXMLString(value) + "\"/>" + Tools.getLineSeparator();
        }
        return "";
    }
}

