/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.test;

import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.test.AssociationRuleGeneratorDataSampleTest;
import com.rapidminer.test.AttributeWeightsDataSampleTest;
import com.rapidminer.test.DistributionModelSampleDataTest;
import com.rapidminer.test.ExampleSetDataSampleTest;
import com.rapidminer.test.ExampleSetsDataSampleTest;
import com.rapidminer.test.FrequentItemSetsDataSampleTest;
import com.rapidminer.test.IOConsumingDataSampleTest;
import com.rapidminer.test.ParameterIterationDataSampleTest;
import com.rapidminer.test.ParameterSetDataSampleTest;
import com.rapidminer.test.RapidMinerTestCase;
import com.rapidminer.test.SVMModelSampleDataTest;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public abstract class OperatorDataSampleTest
extends RapidMinerTestCase {
    protected String file;

    public OperatorDataSampleTest(String file) {
        super("sampleTest");
        this.file = file;
    }

    public String getName() {
        return "Sample '" + this.file + "'";
    }

    public void sampleTest() throws Exception {
        File processFile = new File(ParameterService.getRapidMinerHome(), "test" + File.separator + this.file);
        if (!processFile.exists()) {
            throw new Exception("File '" + processFile.getAbsolutePath() + "' does not exist!");
        }
        LogService.getGlobal().setVerbosityLevel(9);
        Process process = RapidMiner.readProcessFile(processFile);
        IOContainer output = process.run(new IOContainer(), 9);
        this.checkOutput(output);
    }

    public abstract void checkOutput(IOContainer var1) throws MissingIOObjectException;

    public static Test suite() throws Exception {
        RapidMiner.init();
        LogService.getGlobal().setVerbosityLevel(9);
        TestSuite suite = new TestSuite("Sample test");
        suite.addTest((Test)new ExampleSetDataSampleTest("ModelApplier.xml", "confidence(positive)", new double[]{0.3333333333333333, 0.3333333333333333, 0.3333333333333333}));
        suite.addTest((Test)new ExampleSetDataSampleTest("IO" + File.separator + "Generator" + File.separator + "ExampleSetGeneratorSum.xml", "label", new double[]{1.9528130464362032, -8.363305876037725, -3.1404801374055165}));
        suite.addTest((Test)new ExampleSetDataSampleTest("IO" + File.separator + "Generator" + File.separator + "ExampleSetGeneratorSinus.xml", "label", new double[]{-0.053648489595151116, -1.7483138995837275, 0.18967612209762974}));
        suite.addTest((Test)new ExampleSetDataSampleTest("IO" + File.separator + "Generator" + File.separator + "ExampleSetGeneratorSimplePolynomialClassification.xml", "label", new String[]{"negative", "positive", "positive"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("IO" + File.separator + "Generator" + File.separator + "ExampleSetGeneratorThreeRingClusters.xml", "label", new String[]{"first_ring", "core", "second_ring"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("IO" + File.separator + "Generator" + File.separator + "NominalExampleSetGenerator.xml", "label", new String[]{"negative", "positive", "positive"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("IO" + File.separator + "Generator" + File.separator + "MassiveDataGenerator.xml", "label", new String[]{"negative", "positive", "negative"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("IO" + File.separator + "Generator" + File.separator + "MultipleLabelGenerator.xml", "label1", new String[]{"negative", "positive", "positive"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("IO" + File.separator + "Generator" + File.separator + "MultipleLabelGenerator.xml", "label2", new String[]{"positive", "negative", "positive"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("IO" + File.separator + "Generator" + File.separator + "MultipleLabelGenerator.xml", "label3", new String[]{"negative", "negative", "negative"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("IO" + File.separator + "Generator" + File.separator + "MultipleLabelGeneratorWithRegression.xml", "label1", new double[]{-14.463832742801474, 11.879309946870846, 15.043732722905334}));
        suite.addTest((Test)new ExampleSetDataSampleTest("IO" + File.separator + "Generator" + File.separator + "MultipleLabelGeneratorWithRegression.xml", "label2", new double[]{12.186104360682329, -1.448569467214801, 0.304010038276898}));
        suite.addTest((Test)new ExampleSetDataSampleTest("IO" + File.separator + "Generator" + File.separator + "MultipleLabelGeneratorWithRegression.xml", "label3", new double[]{51.438286531689805, 75.4127485170661, 29.08974474321256}));
        suite.addTest((Test)new ExampleSetDataSampleTest("IO" + File.separator + "Examples" + File.separator + "BibTexExampleSource.xml", "bibtype", new String[]{"incollection", "book"}));
        suite.addTest((Test)new AttributeWeightsDataSampleTest("IO" + File.separator + "Attributes" + File.separator + "AttributeWeightsWriter.xml", new String[]{"att1", "att2"}, new double[]{0.0, 1.0}));
        suite.addTest((Test)new AttributeWeightsDataSampleTest("IO" + File.separator + "Attributes" + File.separator + "AttributeWeightsLoader.xml", new String[]{"att1", "att2"}, new double[]{0.0, 1.0}));
        suite.addTest((Test)new IOConsumingDataSampleTest("Core" + File.separator + "IOMultiplierAttributeWeights.xml", 1));
        suite.addTest((Test)new IOConsumingDataSampleTest("Core" + File.separator + "IOMultiplierExampleSet.xml", 1));
        suite.addTest((Test)new IOConsumingDataSampleTest("Core" + File.separator + "IOConsumerAttributeWeights.xml", 1));
        suite.addTest((Test)new IOConsumingDataSampleTest("Core" + File.separator + "IOConsumerExampleSet.xml", 1));
        suite.addTest((Test)new IOConsumingDataSampleTest("Core" + File.separator + "IOConsumer_delete_one.xml", 1));
        suite.addTest((Test)new ExampleSetDataSampleTest("IO" + File.separator + "Examples" + File.separator + "ArffExampleSource.xml", "label", new double[]{1.9528130464362032, -8.363305876037725, -3.1404801374055165}));
        suite.addTest((Test)new DistributionModelSampleDataTest("Learner" + File.separator + "Supervised" + File.separator + "Bayes" + File.separator + "NaiveBayes.xml", new double[]{0.9, 0.1666666666666666, 0.0384615385, 0.9782608696}));
        suite.addTest((Test)new SVMModelSampleDataTest("Learner" + File.separator + "Supervised" + File.separator + "Functions" + File.separator + "EvoSVM.xml", new double[]{77.23214088668192, -7.332858952003095, 536.0619409998441, 234.7202021155585}));
        suite.addTest((Test)new SVMModelSampleDataTest("Learner" + File.separator + "Supervised" + File.separator + "Functions" + File.separator + "GaussianProcesses.xml", new double[]{-14.471909578199531, -5.723394720354495, 21.791351540462667, 6.7619388781725105, -8.572869269432962}));
        suite.addTest((Test)new SVMModelSampleDataTest("Learner" + File.separator + "Supervised" + File.separator + "Functions" + File.separator + "JMySVMLearner.xml", new double[]{-0.08466553720730552, -3.813066593713039, 1.0499144813373242}));
        suite.addTest((Test)new SVMModelSampleDataTest("Learner" + File.separator + "Supervised" + File.separator + "Functions" + File.separator + "LibSVMLearner.xml", new double[]{1.0, -0.345457362826704, -0.32712327331360336, -0.3274193638596926}));
        suite.addTest((Test)new SVMModelSampleDataTest("Learner" + File.separator + "Supervised" + File.separator + "Functions" + File.separator + "PsoSVM.xml", new double[]{-0.6362404930321264, -0.1294041385736771, -1.0}));
        suite.addTest((Test)new SVMModelSampleDataTest("Learner" + File.separator + "Supervised" + File.separator + "Functions" + File.separator + "RVMLearner.xml", new double[]{-1.6367200978545418, 2.8715457495411156}));
        suite.addTest((Test)new SVMModelSampleDataTest("Learner" + File.separator + "Supervised" + File.separator + "Functions" + File.separator + "MyKLRLearner.xml", new double[]{0.812589827620005, -0.37081139693030474, 0.5000000001, -0.1291886031696953}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Functions" + File.separator + "LinearRegression.xml", "prediction(label)", new double[]{0.49769388220887306, -0.48919864419717374, -0.38597602207893167, -0.6213089983982649}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Functions" + File.separator + "LogisticRegression.xml", "confidence(negative)", new double[]{0.3935975586006201, 0.6224411539423208, 0.37876411715595226, 0.37893116784114583}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Functions" + File.separator + "NeuralNet.xml", "confidence(negative)", new double[]{0.3030661429430265, 0.7153779840732098, 0.2997422624229046, 0.29921794684298986}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Lazy" + File.separator + "AttributeBasedVote.xml", "prediction(label)", new double[]{-0.9974318698487723, -6.698643011401726, -0.1695184445644422, 5.227419088571385}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Lazy" + File.separator + "DefaultLearner.xml", "prediction(label)", new double[]{-0.09501652738425875, 1.3171696991768367, 0.6471053689374655, -0.09501652738425875}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Lazy" + File.separator + "NearestNeighbors.xml", "prediction(label)", new String[]{"core", "first_ring", "core", "core", "first_ring"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Meta" + File.separator + "AdaBoost.xml", "confidence(negative)", new double[]{0.5185185185185187, 0.5185185185185187, 0.5185185185185187, 0.5555555555555556}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Rules" + File.separator + "BasicRuleLearner.xml", "prediction(label)", new String[]{"cluster3", "cluster3", "cluster1"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Rules" + File.separator + "BestRuleInduction.xml", "prediction(label)", new String[]{"positive", "negative", "positive"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Rules" + File.separator + "OneR.xml", "prediction(label)", new String[]{"positive", "negative", "positive"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Rules" + File.separator + "RuleLearner.xml", "prediction(label)", new String[]{"positive", "negative", "negative"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Meta" + File.separator + "AdaBoost.xml", "confidence(negative)", new double[]{0.5185185185185187, 0.5185185185185187, 0.5185185185185187, 0.5555555555555556}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Trees" + File.separator + "CHAID.xml", "confidence(negative)", new double[]{0.06666666666666667, 0.9166666666666666, 0.9166666666666666, 0.06666666666666667, 0.9166666666666666}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Trees" + File.separator + "DecisionStump.xml", "confidence(negative)", new double[]{0.8260869565217391, 0.8, 0.2222222222222222, 0.09090909090909091, 0.8}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Trees" + File.separator + "DecisionTree.xml", "confidence(core)", new double[]{0.0, 0.9, 0.8181818181818182, 0.9}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Trees" + File.separator + "ID3.xml", "confidence(negative)", new double[]{0.75, 1.0, 0.5714285714285714, 0.0, 0.5555555555555556}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Trees" + File.separator + "ID3Numerical.xml", "confidence(negative)", new double[]{1.0, 1.0, 1.0, 0.09090909090909091, 1.0}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Trees" + File.separator + "MultiCriterionDecisionStump.xml", "prediction(label)", new String[]{"negative", "negative", "negative", "positive", "negative", "positive", "negative", "positive"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Trees" + File.separator + "RandomForest.xml", "prediction(label)", new String[]{"core", "first_ring", "core", "first_ring", "first_ring", "first_ring", "first_ring", "second_ring"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Trees" + File.separator + "RandomTree.xml", "prediction(label)", new String[]{"first_ring", "core", "second_ring", "core", "first_ring", "second_ring", "second_ring", "core"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Trees" + File.separator + "RelevanceTree.xml", "prediction(label)", new String[]{"second_ring", "core", "second_ring", "core", "first_ring", "core", "first_ring", "core"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Weka" + File.separator + "W-J48.xml", "prediction(label)", new String[]{"first_ring", "core", "second_ring", "core", "first_ring", "first_ring", "first_ring", "core"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Weka" + File.separator + "W-M5Rules.xml", "prediction(label)", new double[]{13894.524850835136, 11294.9365366086, 5380.763904916719, 10444.78985699569, 17353.230976287305, 2936.2985714882197, 13743.825210494664}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Supervised" + File.separator + "Weka" + File.separator + "W-SimpleLinearRegression.xml", "prediction(label)", new double[]{15680.31318695116, 5552.663075337349, 6745.007140990247, 3799.3466182731026, 9563.151904535132, 13100.833236244614, 16460.532143142416}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Unsupervised" + File.separator + "Clustering" + File.separator + "AgglomerativeClustering.xml", "cluster", new String[]{"id 203", "id 209", "id 209", "id 209", "id 206", "id 206", "id 203"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Unsupervised" + File.separator + "Clustering" + File.separator + "DBScanClustering.xml", "cluster", new String[]{"1", "2", "2", "2", "3", "3", "1"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Unsupervised" + File.separator + "Clustering" + File.separator + "ExampleSet2ClusterModel.xml", "cluster", new String[]{"1", "2", "2", "2", "3", "3", "1"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Unsupervised" + File.separator + "Clustering" + File.separator + "KMeans.xml", "cluster", new String[]{"2", "0", "0", "0", "1", "1", "2"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Unsupervised" + File.separator + "Clustering" + File.separator + "KMedoids.xml", "cluster", new String[]{"1", "0", "0", "0", "0", "0", "1"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Unsupervised" + File.separator + "Clustering" + File.separator + "KernelKMeans.xml", "cluster", new String[]{"0", "0", "0", "0", "1", "1", "0"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Unsupervised" + File.separator + "Clustering" + File.separator + "RandomFlatClustering.xml", "cluster", new String[]{"1", "1", "1", "1", "1", "1", "0"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Unsupervised" + File.separator + "Clustering" + File.separator + "SupportVectorClustering.xml", "cluster", new String[]{"1", "2", "2", "2", "3", "3", "1"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Unsupervised" + File.separator + "Clustering" + File.separator + "TopDownClustering.xml", "cluster", new String[]{"cl.1", "cl.0.1", "cl.0.0.0.1", "cl.0.0.0.0", "cl.2", "cl.3", "cl.0.2"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Unsupervised" + File.separator + "Clustering" + File.separator + "TopDownRandomClustering.xml", "cluster", new String[]{"cl.1.1.1.0.0", "cl.1.1.0.0.2", "cl.0.1.0.1.2", "cl.0.0.1.1.0", "cl.0.1.1.1.1", "cl.1.2", "cl.1.1.0.1.0"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Unsupervised" + File.separator + "Clustering" + File.separator + "UPGMAClustering.xml", "cluster", new String[]{"0.0", "0.0", "0.1.0", "0.1.0", "0.1.0", "0.1.0", "0.1.1"}));
        suite.addTest((Test)new FrequentItemSetsDataSampleTest("Learner" + File.separator + "Unsupervised" + File.separator + "Itemsets" + File.separator + "FPGrowth.xml", 0, new String[]{"att3", "att4", "att2", "att5", "att1"}));
        suite.addTest((Test)new AssociationRuleGeneratorDataSampleTest("Learner" + File.separator + "Unsupervised" + File.separator + "Itemsets" + File.separator + "AssociationRuleGenerator.xml", new double[]{1.0}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Unsupervised" + File.separator + "Clustering" + File.separator + "Weka" + File.separator + "W-SimpleKMeans.xml", "cluster", new String[]{"cluster1", "cluster1", "cluster0", "cluster0", "cluster0", "cluster0", "cluster0"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Learner" + File.separator + "Unsupervised" + File.separator + "Clustering" + File.separator + "Weka" + File.separator + "W-FarthestFirst.xml", "cluster", new String[]{"cluster0", "cluster0", "cluster1", "cluster1", "cluster1", "cluster1", "cluster1"}));
        suite.addTest((Test)new AttributeWeightsDataSampleTest("Meta" + File.separator + "AverageBuilder_with_attribute_weighting.xml", new String[]{"att1", "att2", "att3", "att4", "att5"}, new double[]{0.0296060589130663, 0.45370765617859954, 1.0, 0.042861161260176764, 0.1929268735189445}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Meta" + File.separator + "ClusterIteration.xml", "cluster", new double[]{0.0, 1.0, 0.0, 1.0, 0.0}));
        suite.addTest((Test)new ExampleSetsDataSampleTest("Meta" + File.separator + "ExampleSetIterator.xml", "att1", new String[][]{{"true", "false", "true", "true", "false"}, {"true", "false", "false", "false", "true"}}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Meta" + File.separator + "ProcessEmbedder.xml", "prediction(label)", new double[]{-0.09501652738425875, 1.3171696991768367, 0.6471053689374655, -0.09501652738425875, 1.3171696991768367}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Meta" + File.separator + "MultipleLabelIterator.xml", "label", new String[]{"up", "down", "up", "up", "down"}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Meta" + File.separator + "OperatorEnabler.xml", "label", new double[]{1.6431634962865138, 1.9475844940566178, 2.218002556787387, 3.370940882491232, 3.4238369022633175}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Meta" + File.separator + "OperatorEnabler_disabled.xml", "label", new double[]{10.976406523218103, 5.818347061981138, 8.429759931297243, 14.801574008444156, 2.218002556787387}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Meta" + File.separator + "XVPrediction.xml", 1));
        suite.addTest((Test)new ParameterSetDataSampleTest("Meta" + File.separator + "Parameter" + File.separator + "EvolutionaryParameterOptimization.xml", 120.573));
        suite.addTest((Test)new ParameterSetDataSampleTest("Meta" + File.separator + "Parameter" + File.separator + "GridParameterOptimization.xml", 111.421));
        suite.addTest((Test)new ExampleSetDataSampleTest("Meta" + File.separator + "Parameter" + File.separator + "ParameterCloner.xml", 2));
        suite.addTest((Test)new ParameterIterationDataSampleTest("Meta" + File.separator + "Parameter" + File.separator + "ParameterIteration.xml", 6, new int[]{100, 150, 200, 100, 150, 200}, new double[]{-3.1875059108590245, 24.15281909749461, -13.194648154237068, 0.2711377216669635, 0.41740095709333125, 0.6066513878406207}));
        suite.addTest((Test)new ExampleSetDataSampleTest("Meta" + File.separator + "Parameter" + File.separator + "ParameterSetter.xml", 1));
        suite.addTest((Test)new ParameterSetDataSampleTest("Meta" + File.separator + "Parameter" + File.separator + "QuadraticParameterOptimization.xml", 111.421));
        return suite;
    }

    public static void main(String[] argv) throws Exception {
        LogService.getGlobal().setVerbosityLevel(9);
        RapidMiner.init(true, false, false, false);
        LogService.getGlobal().setVerbosityLevel(9);
        TestRunner.run((Test)OperatorDataSampleTest.suite());
    }
}

