/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class TimeFormat {
    public static final long SEC_MS = 1000L;
    public static final long MIN_MS = 60000L;
    public static final long HOUR_MS = 3600000L;
    public static final long DAY_MS = 86400000L;
    public static final long WEEK_MS = 604800000L;
    private NumberFormat numberFormat = null;

    public TimeFormat() {
        this(new DecimalFormat("0"));
    }

    public TimeFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public String format(long timeInMilliseconds) {
        boolean showUnit;
        StringBuffer result = new StringBuffer();
        if (timeInMilliseconds > 604800000L) {
            long weeks = timeInMilliseconds / 604800000L;
            result.append(String.valueOf(this.numberFormat.format(weeks)) + " Week");
            if (weeks > 1L) {
                result.append("s");
            }
            timeInMilliseconds -= weeks * 604800000L;
            result.append(" ");
        }
        boolean showHours = false;
        if (timeInMilliseconds > 86400000L) {
            long days = timeInMilliseconds / 86400000L;
            result.append(String.valueOf(this.numberFormat.format(days)) + " Day");
            if (days > 1L) {
                result.append("s");
            }
            timeInMilliseconds -= days * 86400000L;
            result.append(" ");
            showHours = true;
        }
        boolean showMinutes = false;
        if (timeInMilliseconds > 3600000L) {
            long hours = timeInMilliseconds / 3600000L;
            result.append(String.valueOf(this.appendLeadingZeros(this.numberFormat.format(hours))) + ":");
            timeInMilliseconds -= hours * 3600000L;
            showMinutes = true;
        } else if (showHours) {
            result.append("00:");
            showMinutes = true;
        }
        boolean showSeconds = false;
        if (timeInMilliseconds > 60000L) {
            long minutes = timeInMilliseconds / 60000L;
            if (showMinutes) {
                result.append(String.valueOf(this.appendLeadingZeros(this.numberFormat.format(minutes))) + ":");
            } else {
                result.append(String.valueOf(this.numberFormat.format(minutes)) + ":");
            }
            timeInMilliseconds -= minutes * 60000L;
            showSeconds = true;
        } else if (showMinutes) {
            result.append("00:");
            showSeconds = true;
        }
        boolean bl = showUnit = result.length() == 0;
        if (timeInMilliseconds > 1000L) {
            long seconds = timeInMilliseconds / 1000L;
            if (showSeconds) {
                result.append(this.appendLeadingZeros(this.numberFormat.format(seconds)));
            } else {
                result.append(this.numberFormat.format(seconds));
            }
        } else if (showSeconds) {
            result.append("00");
        }
        if (showUnit && result.length() > 0) {
            result.append(" s");
        }
        if (result.length() == 0) {
            result.append("0 s");
        }
        return result.toString();
    }

    private String appendLeadingZeros(String number) {
        if (number.length() < 2) {
            return "0" + number;
        }
        return number;
    }
}

