/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.FDistribution;
import com.rapidminer.tools.math.SignificanceCalculationException;
import com.rapidminer.tools.math.SignificanceTestResult;
import com.rapidminer.tools.math.TestGroup;
import java.awt.Color;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;

public class AnovaCalculator {
    private double alpha = 0.05;
    private List<TestGroup> groups = new LinkedList<TestGroup>();

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public void addGroup(TestGroup group) {
        this.groups.add(group);
    }

    public void addGroup(double numberOfValues, double mean, double variance) {
        this.addGroup(new TestGroup(numberOfValues, mean, variance));
    }

    public void clearGroups() {
        this.groups.clear();
    }

    public SignificanceTestResult performSignificanceTest() throws SignificanceCalculationException {
        if (this.groups.size() < 2) {
            throw new SignificanceCalculationException("Cannot calculate ANOVA: not enough groups added (current number of groups: " + this.groups.size() + ", must be at least 2");
        }
        double meanOfMeans = 0.0;
        for (TestGroup group : this.groups) {
            meanOfMeans += group.getMean();
        }
        meanOfMeans /= (double)this.groups.size();
        double sumSquaresBetween = 0.0;
        for (TestGroup group : this.groups) {
            double diff = group.getMean() - meanOfMeans;
            sumSquaresBetween += group.getNumber() * (diff * diff);
        }
        double sumSquaresResiduals = 0.0;
        int counterSum = 0;
        for (TestGroup group : this.groups) {
            sumSquaresResiduals += (group.getNumber() - 1.0) * group.getVariance();
            counterSum = (int)((double)counterSum + group.getNumber());
        }
        return new AnovaSignificanceTestResult(sumSquaresBetween, sumSquaresResiduals, this.groups.size() - 1, counterSum - this.groups.size(), this.alpha);
    }

    public static class AnovaSignificanceTestResult
    extends SignificanceTestResult {
        private static final long serialVersionUID = 9007616378489018565L;
        private double sumSquaresBetween = 0.0;
        private double sumSquaresResiduals = 0.0;
        private double meanSquaresBetween = 0.0;
        private double meanSquaresResiduals = 0.0;
        private int df1 = 0;
        private int df2 = 0;
        private double alpha = 0.05;
        private double fValue = 0.0;
        private double prob = 0.0;

        public AnovaSignificanceTestResult(double sumSquaresBetween, double sumSquaresResiduals, int df1, int df2, double alpha) {
            this.sumSquaresBetween = sumSquaresBetween;
            this.sumSquaresResiduals = sumSquaresResiduals;
            this.df1 = df1;
            this.df2 = df2;
            this.alpha = alpha;
            this.meanSquaresBetween = sumSquaresBetween / (double)df1;
            this.meanSquaresResiduals = sumSquaresResiduals / (double)df2;
            this.fValue = this.meanSquaresBetween / this.meanSquaresResiduals;
            FDistribution fDist = new FDistribution(df1, df2);
            this.prob = fDist.getProbabilityForValue(this.fValue);
            this.prob = this.prob < 0.0 ? 1.0 : 1.0 - this.prob;
        }

        public String getName() {
            return "Anova Test";
        }

        public String toString() {
            return "ANOVA result (f=" + Tools.formatNumber(this.fValue) + ", prob=" + Tools.formatNumber(this.prob) + ", alpha=" + Tools.formatNumber(this.alpha) + ")";
        }

        public double getProbability() {
            return this.prob;
        }

        public Component getVisualizationComponent(IOContainer container) {
            StringBuffer buffer = new StringBuffer();
            Color bgColor = SwingTools.LIGHTEST_YELLOW;
            String bgColorString = "#" + Integer.toHexString(bgColor.getRed()) + Integer.toHexString(bgColor.getGreen()) + Integer.toHexString(bgColor.getBlue());
            Color headerColor = SwingTools.LIGHTEST_BLUE;
            String headerColorString = "#" + Integer.toHexString(headerColor.getRed()) + Integer.toHexString(headerColor.getGreen()) + Integer.toHexString(headerColor.getBlue());
            buffer.append("<table bgcolor=\"" + bgColorString + "\" border=\"1\">");
            buffer.append("<tr bgcolor=\"" + headerColorString + "\"><th>Source</th><th>Square Sums</th><th>DF</th><th>Mean Squares</th><th>F</th><th>Prob</th></tr>");
            buffer.append("<tr><td>Between</td><td>" + Tools.formatNumber(this.sumSquaresBetween) + "</td><td>" + this.df1 + "</td><td>" + Tools.formatNumber(this.meanSquaresBetween) + "</td><td>" + Tools.formatNumber(this.fValue) + "</td><td>" + Tools.formatNumber(this.prob) + "</td></tr>");
            buffer.append("<tr><td>Residuals</td><td>" + Tools.formatNumber(this.sumSquaresResiduals) + "</td><td>" + this.df2 + "</td><td>" + Tools.formatNumber(this.meanSquaresResiduals) + "</td><td></td><td></td></tr>");
            buffer.append("<tr><td>Total</td><td>" + Tools.formatNumber(this.sumSquaresBetween + this.sumSquaresResiduals) + "</td><td>" + (this.df1 + this.df2) + "</td><td></td><td></td><td></td></tr>");
            buffer.append("</table>");
            buffer.append("<br>Probability for random values with the same result: " + Tools.formatNumber(this.prob) + "<br>");
            if (this.prob < this.alpha) {
                buffer.append("Difference between actual mean values is probably significant, since " + Tools.formatNumber(this.prob) + " &lt; alpha = " + Tools.formatNumber(this.alpha) + "!");
            } else {
                buffer.append("Difference between actual mean values is probably not significant, since " + Tools.formatNumber(this.prob) + " &gt; alpha = " + Tools.formatNumber(this.alpha) + "!");
            }
            JEditorPane textPane = new JEditorPane("text/html", "<html><h1>" + this.getName() + "</h1>" + buffer.toString() + "</html>");
            textPane.setBackground(new JLabel().getBackground());
            textPane.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
            return new ExtendedJScrollPane(textPane);
        }
    }
}

