/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import Jama.Matrix;

public class LinearRegression {
    public static double[] performRegression(Matrix x, Matrix y, double[] weights, double ridge) {
        Matrix weightedIndependent = new Matrix(x.getRowDimension(), x.getColumnDimension());
        Matrix weightedDependent = new Matrix(x.getRowDimension(), 1);
        int i = 0;
        while (i < weights.length) {
            double sqrtWeight = Math.sqrt(weights[i]);
            int j = 0;
            while (j < x.getColumnDimension()) {
                weightedIndependent.set(i, j, x.get(i, j) * sqrtWeight);
                ++j;
            }
            weightedDependent.set(i, 0, y.get(i, 0) * sqrtWeight);
            ++i;
        }
        return LinearRegression.performRegression(weightedIndependent, weightedDependent, ridge);
    }

    public static double[] performRegression(Matrix x, Matrix y, double ridge) {
        int numberOfColumns = x.getColumnDimension();
        double[] coefficients = new double[numberOfColumns];
        Matrix xTransposed = x.transpose();
        boolean finished = false;
        while (!finished) {
            Matrix xTx = xTransposed.times(x);
            int i = 0;
            while (i < numberOfColumns) {
                xTx.set(i, i, xTx.get(i, i) + ridge);
                ++i;
            }
            Matrix xTy = xTransposed.times(y);
            int i2 = 0;
            while (i2 < numberOfColumns) {
                coefficients[i2] = xTy.get(i2, 0);
                ++i2;
            }
            try {
                Matrix result = xTx.solve(new Matrix(coefficients, coefficients.length));
                i2 = 0;
                while (i2 < numberOfColumns) {
                    coefficients[i2] = result.get(i2, 0);
                    ++i2;
                }
                finished = true;
            }
            catch (Exception ex) {
                ridge *= 10.0;
                finished = false;
            }
        }
        return coefficients;
    }
}

