/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathFunctions {
    protected static final double log2 = Math.log(2.0);
    protected static final double[] DIVISOR_COEFFICIENTS_0 = new double[]{-59.96335010141079, 98.00107541859997, -56.67628574690703, 13.931260938727968, -1.2391658386738125};
    protected static final double[] DIVIDER_COEFFICIENTS_0 = new double[]{1.0, 1.9544885833814176, 4.676279128988815, 86.36024213908905, -225.46268785411937, 200.26021238006066, -82.03722561683334, 15.90562251262117, -1.1833162112133};
    protected static final double[] DIVISOR_COEFFICIENTS_1 = new double[]{4.0554489230596245, 31.525109459989388, 57.16281922464213, 44.08050738932008, 14.684956192885803, 2.1866330685079025, -0.1402560791713545, -0.03504246268278482, -8.574567851546854E-4};
    protected static final double[] DIVIDER_COEFFICIENTS_1 = new double[]{1.0, 15.779988325646675, 45.39076351288792, 41.3172038254672, 15.04253856929075, 2.504649462083094, -0.14218292285478779, -0.03808064076915783, -9.332594808954574E-4};
    protected static final double[] DIVISOR_COEFFICIENTS_3 = new double[]{3.2377489177694603, 6.915228890689842, 3.9388102529247444, 1.3330346081580755, 0.20148538954917908, 0.012371663481782003, 3.0158155350823543E-4, 2.6580697468673755E-6, 6.239745391849833E-9};
    protected static final double[] DIVIDER_COEFFICIENTS_3 = new double[]{1.0, 6.02427039364742, 3.6798356385616087, 1.3770209948908132, 0.21623699359449663, 0.013420400608854318, 3.2801446468212774E-4, 2.8924786474538068E-6, 6.790194080099813E-9};

    public static double tanh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / (Math.exp(x) + Math.exp(-x));
    }

    public static double normalInverse(double probability) {
        double smallArgumentEnd = Math.exp(-2.0);
        double rootedPi = Math.sqrt(Math.PI * 2);
        if (probability <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (probability >= 1.0) {
            throw new IllegalArgumentException();
        }
        boolean wrappedArround = false;
        if (probability > 1.0 - smallArgumentEnd) {
            probability = 1.0 - probability;
            wrappedArround = true;
        }
        if (probability > smallArgumentEnd) {
            double squaredProbability = (probability -= 0.5) * probability;
            double x = probability;
            x += probability * (squaredProbability * MathFunctions.solvePolynomial(squaredProbability, DIVISOR_COEFFICIENTS_0) / MathFunctions.solvePolynomial(squaredProbability, DIVIDER_COEFFICIENTS_0));
            return x *= rootedPi;
        }
        double x = Math.sqrt(-2.0 * Math.log(probability));
        double inversedX = 1.0 / x;
        x = x < 8.0 ? x - Math.log(x) / x - inversedX * MathFunctions.solvePolynomial(inversedX, DIVISOR_COEFFICIENTS_1) / MathFunctions.solvePolynomial(inversedX, DIVIDER_COEFFICIENTS_1) : x - Math.log(x) / x - inversedX * MathFunctions.solvePolynomial(inversedX, DIVISOR_COEFFICIENTS_3) / MathFunctions.solvePolynomial(inversedX, DIVIDER_COEFFICIENTS_3);
        if (!wrappedArround) {
            x = -x;
        }
        return x;
    }

    public static double solvePolynomial(double x, double[] coefficients) {
        double value = coefficients[0];
        int i = 1;
        while (i < coefficients.length) {
            value += coefficients[i] * Math.pow(x, i);
            ++i;
        }
        return value;
    }

    public static double variance(double[] v, double a) {
        double sum = 0.0;
        int counter = 0;
        int i = 0;
        while (i < v.length) {
            if (v[i] >= a) {
                sum += v[i];
                ++counter;
            }
            ++i;
        }
        double mean = sum / (double)counter;
        sum = 0.0;
        counter = 0;
        int i2 = 0;
        while (i2 < v.length) {
            if (v[i2] >= a) {
                sum += (v[i2] - mean) * (v[i2] - mean);
                ++counter;
            }
            ++i2;
        }
        double variance = sum / (double)counter;
        return variance;
    }

    public static double correlation(ExampleSet exampleSet, Attribute firstAttribute, Attribute secondAttribute, boolean squared) {
        double sumProd = 0.0;
        double sumFirst = 0.0;
        double sumSecond = 0.0;
        double sumFirstSquared = 0.0;
        double sumSecondSquared = 0.0;
        int counter = 0;
        for (Example example : exampleSet) {
            double second;
            double first = example.getValue(firstAttribute);
            double prod = first * (second = example.getValue(secondAttribute));
            if (Double.isNaN(prod)) continue;
            sumProd += prod;
            sumFirst += first;
            sumFirstSquared += first * first;
            sumSecond += second;
            sumSecondSquared += second * second;
            ++counter;
        }
        double r = ((double)counter * sumProd - sumFirst * sumSecond) / Math.sqrt(((double)counter * sumFirstSquared - sumFirst * sumFirst) * ((double)counter * sumSecondSquared - sumSecond * sumSecond));
        if (squared) {
            return r * r;
        }
        return r;
    }

    public static double correlation(double[] x1, double[] x2) {
        int counter = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sumS1 = 0.0;
        double sumS2 = 0.0;
        int i = 0;
        while (i < x1.length) {
            sum1 += x1[i];
            sum2 += x2[i];
            ++counter;
            ++i;
        }
        double mean1 = sum1 / (double)counter;
        double mean2 = sum2 / (double)counter;
        double sum = 0.0;
        counter = 0;
        int i2 = 0;
        while (i2 < x1.length) {
            sum += (x1[i2] - mean1) * (x2[i2] - mean2);
            sumS1 += (x1[i2] - mean1) * (x1[i2] - mean1);
            sumS2 += (x2[i2] - mean2) * (x2[i2] - mean2);
            ++counter;
            ++i2;
        }
        return sum / Math.sqrt(sumS1 * sumS2);
    }

    public static double robustMin(double m1, double m2) {
        double min = Math.min(m1, m2);
        if (!Double.isNaN(min)) {
            return min;
        }
        if (Double.isNaN(m1)) {
            return m2;
        }
        return m1;
    }

    public static double robustMax(double m1, double m2) {
        double max = Math.max(m1, m2);
        if (!Double.isNaN(max)) {
            return max;
        }
        if (Double.isNaN(m1)) {
            return m2;
        }
        return m1;
    }

    public static double ld(double value) {
        return Math.log(value) / log2;
    }

    public static long getGCD(long a, long b) {
        while (b != 0L) {
            long c = a % b;
            a = b;
            b = c;
        }
        return a;
    }

    public static long getGCD(Collection<Long> collection) {
        boolean first = true;
        long currentGCD = 1L;
        for (long value : collection) {
            if (first) {
                currentGCD = value;
                first = false;
                continue;
            }
            currentGCD = MathFunctions.getGCD(currentGCD, value);
        }
        return currentGCD;
    }
}

