/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.optimization.ec.es;

import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.gui.plotter.SimplePlotterDialog;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.optimization.Optimization;
import com.rapidminer.tools.math.optimization.ec.es.BoltzmannSelection;
import com.rapidminer.tools.math.optimization.ec.es.Crossover;
import com.rapidminer.tools.math.optimization.ec.es.CutSelection;
import com.rapidminer.tools.math.optimization.ec.es.GaussianMutation;
import com.rapidminer.tools.math.optimization.ec.es.Individual;
import com.rapidminer.tools.math.optimization.ec.es.Mutation;
import com.rapidminer.tools.math.optimization.ec.es.NonDominatedSortingSelection;
import com.rapidminer.tools.math.optimization.ec.es.OptimizationValueType;
import com.rapidminer.tools.math.optimization.ec.es.Population;
import com.rapidminer.tools.math.optimization.ec.es.PopulationOperator;
import com.rapidminer.tools.math.optimization.ec.es.PopulationPlotter;
import com.rapidminer.tools.math.optimization.ec.es.RankSelection;
import com.rapidminer.tools.math.optimization.ec.es.RouletteWheel;
import com.rapidminer.tools.math.optimization.ec.es.SparsityMutation;
import com.rapidminer.tools.math.optimization.ec.es.StochasticUniversalSampling;
import com.rapidminer.tools.math.optimization.ec.es.SwitchingMutation;
import com.rapidminer.tools.math.optimization.ec.es.TournamentSelection;
import com.rapidminer.tools.math.optimization.ec.es.UniformSelection;
import com.rapidminer.tools.math.optimization.ec.es.VarianceAdaption;
import java.awt.Dialog;
import java.awt.Window;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class ESOptimization
implements Optimization {
    public static final String[] SELECTION_TYPES = new String[]{"uniform", "cut", "roulette wheel", "stochastic universal sampling", "Boltzmann", "rank", "tournament", "non dominated sorting"};
    public static final int UNIFORM_SELECTION = 0;
    public static final int CUT_SELECTION = 1;
    public static final int ROULETTE_WHEEL = 2;
    public static final int STOCHASTIC_UNIVERSAL = 3;
    public static final int BOLTZMANN_SELECTION = 4;
    public static final int RANK_SELECTION = 5;
    public static final int TOURNAMENT_SELECTION = 6;
    public static final int NON_DOMINATED_SORTING_SELECTION = 7;
    public static final String[] MUTATION_TYPES = new String[]{"none", "gaussian_mutation", "switching_mutation", "sparsity_mutation"};
    public static final int NO_MUTATION = 0;
    public static final int GAUSSIAN_MUTATION = 1;
    public static final int SWITCHING_MUTATION = 2;
    public static final int SPARSITY_MUTATION = 3;
    public static final String[] POPULATION_INIT_TYPES = new String[]{"random", "min", "max"};
    public static final int INIT_TYPE_RANDOM = 0;
    public static final int INIT_TYPE_MIN = 1;
    public static final int INIT_TYPE_MAX = 2;
    public static final int INIT_TYPE_ONE = 3;
    public static final int INIT_TYPE_ZERO = 4;
    private double[] min;
    private double[] max;
    private OptimizationValueType[] valueTypes;
    private int populationSize;
    private int individualSize;
    private int maxGenerations;
    private int generationsWithoutImprovement;
    private int initType = 0;
    private PopulationPlotter populationPlotter = null;
    private Mutation mutation;
    private Population population;
    private Collection<PopulationOperator> popOps;
    private boolean showConvergencePlot = false;
    private int totalEvalCounter = 0;
    private int actualEvalCounter = 0;
    private RandomGenerator random;
    private LoggingHandler logging;

    public ESOptimization(double minValue, double maxValue, int populationSize, int individualSize, int initType, int maxGenerations, int generationsWithoutImprovement, int selectionType, double tournamentFraction, boolean keepBest, int mutationType, double crossoverProb, boolean showConvergencePlot, boolean showPopulationPlot, RandomGenerator random, LoggingHandler logging) {
        this(ESOptimization.createBoundArray(minValue, individualSize), ESOptimization.createBoundArray(maxValue, individualSize), populationSize, individualSize, initType, maxGenerations, generationsWithoutImprovement, selectionType, tournamentFraction, keepBest, mutationType, Double.NaN, crossoverProb, showConvergencePlot, showPopulationPlot, random, logging);
    }

    public ESOptimization(double[] minValues, double[] maxValues, int populationSize, int individualSize, int initType, int maxGenerations, int generationsWithoutImprovement, int selectionType, double tournamentFraction, boolean keepBest, int mutationType, double defaultSigma, double crossoverProb, boolean showConvergencePlot, boolean showPopulationPlot, RandomGenerator random, LoggingHandler logging) {
        this.logging = logging;
        this.random = random;
        this.showConvergencePlot = showConvergencePlot;
        this.populationSize = populationSize;
        this.individualSize = individualSize;
        this.min = minValues;
        this.max = maxValues;
        this.valueTypes = new OptimizationValueType[individualSize];
        int i = 0;
        while (i < this.valueTypes.length) {
            this.valueTypes[i] = OptimizationValueType.VALUE_TYPE_DOUBLE;
            ++i;
        }
        this.initType = initType;
        this.maxGenerations = maxGenerations;
        this.generationsWithoutImprovement = generationsWithoutImprovement < 1 ? this.maxGenerations : generationsWithoutImprovement;
        this.popOps = new LinkedList<PopulationOperator>();
        switch (selectionType) {
            case 0: {
                this.popOps.add(new UniformSelection(populationSize, keepBest, random));
                break;
            }
            case 1: {
                this.popOps.add(new CutSelection(populationSize));
                break;
            }
            case 2: {
                this.popOps.add(new RouletteWheel(populationSize, keepBest, random));
                break;
            }
            case 3: {
                this.popOps.add(new StochasticUniversalSampling(populationSize, keepBest, random));
                break;
            }
            case 4: {
                this.popOps.add(new BoltzmannSelection(populationSize, 1.0, this.maxGenerations, true, keepBest, random));
                break;
            }
            case 5: {
                this.popOps.add(new RankSelection(populationSize, keepBest, random));
                break;
            }
            case 6: {
                this.popOps.add(new TournamentSelection(populationSize, tournamentFraction, keepBest, random));
                break;
            }
            case 7: {
                this.popOps.add(new NonDominatedSortingSelection(populationSize));
                if (!showPopulationPlot) break;
                this.populationPlotter = new PopulationPlotter();
                this.popOps.add(this.populationPlotter);
            }
        }
        this.popOps.add(new Crossover(crossoverProb, random));
        switch (mutationType) {
            case 1: {
                int s;
                double[] sigma = new double[this.min.length];
                if (!Double.isNaN(defaultSigma)) {
                    s = 0;
                    while (s < sigma.length) {
                        sigma[s] = defaultSigma;
                        ++s;
                    }
                } else {
                    s = 0;
                    while (s < sigma.length) {
                        sigma[s] = (this.max[s] - this.min[s]) / 100.0;
                        ++s;
                    }
                }
                GaussianMutation gm = new GaussianMutation(sigma, this.min, this.max, this.valueTypes, random);
                this.popOps.add(gm);
                this.popOps.add(new VarianceAdaption(gm, individualSize, this.logging));
                this.mutation = gm;
                break;
            }
            case 2: {
                this.mutation = new SwitchingMutation(1.0 / (double)individualSize, this.min, this.max, this.valueTypes, random);
                this.popOps.add(this.mutation);
                break;
            }
            case 3: {
                this.mutation = new SparsityMutation(1.0 / (double)individualSize, this.min, this.max, this.valueTypes, random);
                this.popOps.add(this.mutation);
                break;
            }
        }
    }

    private static double[] createBoundArray(double bound, int size) {
        double[] result = new double[size];
        int i = 0;
        while (i < result.length) {
            result[i] = bound;
            ++i;
        }
        return result;
    }

    public abstract PerformanceVector evaluateIndividual(Individual var1) throws OperatorException;

    public void nextIteration() throws OperatorException {
    }

    public double getMin(int index) {
        return this.min[index];
    }

    public double getMax(int index) {
        return this.max[index];
    }

    public void setMin(int index, double v) {
        this.min[index] = v;
    }

    public void setMax(int index, double v) {
        this.max[index] = v;
    }

    public OptimizationValueType getValueType(int index) {
        return this.valueTypes[index];
    }

    public void setValueType(int index, OptimizationValueType type) {
        this.valueTypes[index] = type;
        this.mutation.setValueType(index, type);
    }

    public void optimize() throws OperatorException {
        this.totalEvalCounter = 0;
        this.actualEvalCounter = 0;
        switch (this.initType) {
            case 0: {
                this.population = this.createRandomStartPopulation();
                break;
            }
            case 1: {
                this.population = this.createMinStartPopulation();
                break;
            }
            case 2: {
                this.population = this.createMaxStartPopulation();
                break;
            }
            case 3: {
                this.population = this.createFixedStartPopulation(1.0);
                break;
            }
            case 4: {
                this.population = this.createFixedStartPopulation(0.0);
                break;
            }
        }
        this.evaluate(this.population);
        SimpleDataTable dataTable = null;
        Window plotter = null;
        if (this.showConvergencePlot) {
            dataTable = new SimpleDataTable("Fitness vs. Generations", new String[]{"Generations", "Best Fitness", "Current Fitness"});
            plotter = new SimplePlotterDialog(dataTable, false);
            ((SimplePlotterDialog)plotter).setXAxis(0);
            ((SimplePlotterDialog)plotter).plotColumn(1, true);
            ((SimplePlotterDialog)plotter).plotColumn(2, true);
            ((Dialog)plotter).setVisible(true);
            dataTable.add(new SimpleDataTableRow(new double[]{0.0, this.population.getBestEver().getFitness().getMainCriterion().getFitness(), this.population.getCurrentBest().getFitness().getMainCriterion().getFitness()}));
        }
        while (true) {
            if (this.population.getGeneration() >= this.maxGenerations) {
                this.logging.log("ES finished: maximum number of iterations reached.");
                break;
            }
            if (this.population.getGenerationsWithoutImprovement() > this.generationsWithoutImprovement) {
                this.logging.log("ES converged in generation " + this.population.getGeneration() + ": No improvement in last " + this.generationsWithoutImprovement + " generations.");
                break;
            }
            Iterator<PopulationOperator> i = this.popOps.iterator();
            while (i.hasNext()) {
                i.next().operate(this.population);
            }
            this.evaluate(this.population);
            if (this.showConvergencePlot) {
                dataTable.add(new SimpleDataTableRow(new double[]{this.population.getGeneration(), this.population.getBestEver().getFitness().getMainCriterion().getFitness(), this.population.getCurrentBest().getFitness().getMainCriterion().getFitness()}));
            }
            this.population.nextGeneration();
            this.nextIteration();
        }
        if (this.showConvergencePlot) {
            plotter.dispose();
        }
        if (this.populationPlotter != null) {
            this.populationPlotter.setCreateOtherPlottersEnabled(true);
        }
        this.logging.log("ES Evaluations: " + this.actualEvalCounter + " / " + this.totalEvalCounter);
    }

    protected void evaluate(Population population) throws OperatorException {
        Individual currentBest = null;
        int i = population.getNumberOfIndividuals() - 1;
        while (i >= 0) {
            Individual current = population.get(i);
            if (current.getFitness() == null) {
                PerformanceVector fitness = this.evaluateIndividual(current);
                if (fitness != null) {
                    current.setFitness(fitness);
                    if (currentBest == null || fitness.getMainCriterion().getFitness() > currentBest.getFitness().getMainCriterion().getFitness()) {
                        currentBest = (Individual)current.clone();
                        currentBest.setFitness(current.getFitness());
                    }
                } else {
                    population.remove(current);
                }
                ++this.actualEvalCounter;
            }
            ++this.totalEvalCounter;
            --i;
        }
        if (currentBest != null) {
            population.setCurrentBest(currentBest);
            Individual bestEver = population.getBestEver();
            if (bestEver == null || currentBest.getFitness().getMainCriterion().getFitness() > bestEver.getFitness().getMainCriterion().getFitness()) {
                Individual bestEverClone = (Individual)currentBest.clone();
                bestEverClone.setFitness(currentBest.getFitness());
                population.setBestEver(bestEverClone);
            }
        }
    }

    public int getGeneration() {
        return this.population.getGeneration();
    }

    public double getBestFitnessInGeneration() {
        Individual individual = this.population.getCurrentBest();
        if (individual != null) {
            return individual.getFitnessValues()[0];
        }
        return Double.NaN;
    }

    public double getBestFitnessEver() {
        Individual individual = this.population.getBestEver();
        if (individual != null) {
            return individual.getFitnessValues()[0];
        }
        return Double.NaN;
    }

    public PerformanceVector getBestPerformanceEver() {
        Individual individual = this.population.getBestEver();
        if (individual != null) {
            return individual.getFitness();
        }
        return null;
    }

    public Population getPopulation() {
        return this.population;
    }

    public double[] getBestValuesEver() {
        Individual individual = this.population.getBestEver();
        if (individual != null) {
            return individual.getValues();
        }
        return null;
    }

    private Population createRandomStartPopulation() {
        Population population = new Population();
        int p = 0;
        while (p < this.populationSize) {
            double[] alphas = new double[this.individualSize];
            int j = 0;
            while (j < alphas.length) {
                boolean upper;
                alphas[j] = this.getValueType(j).equals((Object)OptimizationValueType.VALUE_TYPE_INT) ? (double)((int)Math.round(this.random.nextDoubleInRange(this.min[j], this.max[j]))) : (this.getValueType(j).equals((Object)OptimizationValueType.VALUE_TYPE_BOUNDS) ? ((upper = this.random.nextBoolean()) ? this.max[j] : this.min[j]) : this.random.nextDoubleInRange(this.min[j], this.max[j]));
                ++j;
            }
            population.add(new Individual(alphas));
            ++p;
        }
        return population;
    }

    private Population createMinStartPopulation() {
        Population population = new Population();
        int p = 0;
        while (p < this.populationSize) {
            double[] alphas = new double[this.individualSize];
            int j = 0;
            while (j < alphas.length) {
                alphas[j] = this.min[j];
                ++j;
            }
            population.add(new Individual(alphas));
            ++p;
        }
        return population;
    }

    private Population createMaxStartPopulation() {
        Population population = new Population();
        int p = 0;
        while (p < this.populationSize) {
            double[] alphas = new double[this.individualSize];
            int j = 0;
            while (j < alphas.length) {
                alphas[j] = this.max[j];
                ++j;
            }
            population.add(new Individual(alphas));
            ++p;
        }
        return population;
    }

    private Population createFixedStartPopulation(double fixedValue) {
        Population population = new Population();
        int p = 0;
        while (p < this.populationSize) {
            double[] alphas = new double[this.individualSize];
            int j = 0;
            while (j < alphas.length) {
                alphas[j] = fixedValue;
                ++j;
            }
            population.add(new Individual(alphas));
            ++p;
        }
        return population;
    }

    public void increaseCurrentEvaluationCounter() {
        ++this.actualEvalCounter;
    }

    public void increaseTotalEvaluationCounter() {
        ++this.totalEvalCounter;
    }
}

