/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.optimization.ec.es;

import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.optimization.ec.es.Individual;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Population {
    public static final Comparator<Individual> PERFORMANCE_COMPARATOR = new Comparator<Individual>(){

        @Override
        public int compare(Individual i1, Individual i2) {
            PerformanceVector p1 = i1.getFitness();
            PerformanceVector p2 = i2.getFitness();
            return p1.compareTo(p2);
        }
    };
    private ArrayList<Individual> individuals = new ArrayList();
    private Individual bestEver;
    private Individual currentBest;
    private int generations = 1;
    private int lastImprovement = 1;

    public void clear() {
        this.individuals.clear();
    }

    public void add(Individual individual) {
        this.individuals.add(individual);
    }

    public void addAll(Collection<Individual> newIndividuals) {
        this.individuals.addAll(newIndividuals);
    }

    public void remove(Individual individual) {
        this.individuals.remove(individual);
    }

    public void remove(int i) {
        this.individuals.remove(i);
    }

    public Individual get(int i) {
        return this.individuals.get(i);
    }

    public int getNumberOfIndividuals() {
        return this.individuals.size();
    }

    public void setCurrentBest(Individual currentBest) {
        this.currentBest = currentBest;
    }

    public Individual getCurrentBest() {
        return this.currentBest;
    }

    public void setBestEver(Individual bestEver) {
        this.lastImprovement = this.generations;
        this.bestEver = bestEver;
    }

    public Individual getBestEver() {
        return this.bestEver;
    }

    public void nextGeneration() {
        ++this.generations;
    }

    public int getGeneration() {
        return this.generations;
    }

    public int getGenerationsWithoutImprovement() {
        return this.generations - this.lastImprovement;
    }

    public void sort() {
        Collections.sort(this.individuals, PERFORMANCE_COMPARATOR);
    }

    public void sort(Comparator<Individual> comparator) {
        Collections.sort(this.individuals, comparator);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Population in generation " + this.generations + ":" + Tools.getLineSeparator());
        Iterator<Individual> i = this.individuals.iterator();
        while (i.hasNext()) {
            result.append(i.next() + Tools.getLineSeparator());
        }
        return result.toString();
    }
}

