/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.plugin;

import com.rapidminer.RapidMiner;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.renderer.RendererService;
import com.rapidminer.gui.templates.BuildingBlock;
import com.rapidminer.gui.tools.AboutBox;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.ResourceSource;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.plugin.AllPluginsClassLoader;
import com.rapidminer.tools.plugin.Dependency;
import com.rapidminer.tools.plugin.PluginClassLoader;
import java.awt.Frame;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plugin {
    public static final String RAPIDMINER_TYPE = "RapidMiner-Type";
    public static final String RAPIDMINER_TYPE_PLUGIN = "RapidMiner_Plugin";
    private static final ClassLoader MAJOR_CLASS_LOADER = new AllPluginsClassLoader();
    private JarFile archive;
    private final File file;
    private final PluginClassLoader classLoader;
    private String name;
    private String version;
    private String vendor;
    private String url;
    private String necessaryRapidMinerVersion = "0";
    private final List<Dependency> pluginDependencies = new LinkedList<Dependency>();
    private static List<Plugin> allPlugins = new LinkedList<Plugin>();

    public Plugin(File file) throws IOException {
        this.file = file;
        this.archive = new JarFile(this.file);
        URL url = new URL("file", null, this.file.getAbsolutePath());
        this.classLoader = new PluginClassLoader(new URL[]{url});
        Tools.addResourceSource(new ResourceSource(this.classLoader));
        this.getMetaData();
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getNecessaryRapidMinerVersion() {
        return this.necessaryRapidMinerVersion;
    }

    public List getPluginDependencies() {
        return this.pluginDependencies;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getOriginalClassLoader() {
        try {
            this.archive = new JarFile(this.file);
            URL url = new URL("file", null, this.file.getAbsolutePath());
            return new URLClassLoader(new URL[]{url});
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean checkDependencies(List plugins) {
        if (RapidMiner.getLongVersion().compareTo(this.necessaryRapidMinerVersion) < 0) {
            return false;
        }
        for (Dependency dependency : this.pluginDependencies) {
            if (dependency.isFulfilled(plugins)) continue;
            return false;
        }
        return true;
    }

    private void getMetaData() {
        try {
            String dependencies;
            Attributes atts = this.archive.getManifest().getMainAttributes();
            this.name = atts.getValue("Implementation-Title");
            if (this.name == null) {
                this.name = this.archive.getName();
            }
            this.version = atts.getValue("Implementation-Version");
            if (this.version == null) {
                this.version = "";
            }
            this.url = atts.getValue("Implementation-URL");
            this.vendor = atts.getValue("Implementation-Vendor");
            this.necessaryRapidMinerVersion = atts.getValue("RapidMiner-Version");
            if (this.necessaryRapidMinerVersion == null) {
                this.necessaryRapidMinerVersion = "0";
            }
            if ((dependencies = atts.getValue("Plugin-Dependencies")) == null) {
                dependencies = "";
            }
            this.addDependencies(dependencies);
            RapidMiner.splashMessage("Loading " + this.name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addDependencies(String dependencies) {
        String[] singleDependencies = dependencies.trim().split("#");
        int i = 0;
        while (i < singleDependencies.length) {
            if (singleDependencies[i].trim().length() > 0) {
                String dependencyName = singleDependencies[i].trim();
                String dependencyVersion = "0";
                if (singleDependencies[i].trim().indexOf("[") >= 0) {
                    dependencyName = singleDependencies[i].trim().substring(0, singleDependencies[i].trim().indexOf("[")).trim();
                    dependencyVersion = singleDependencies[i].trim().substring(singleDependencies[i].trim().indexOf("[") + 1, singleDependencies[i].trim().indexOf("]")).trim();
                }
                this.pluginDependencies.add(new Dependency(dependencyName, dependencyVersion));
            }
            ++i;
        }
    }

    public void register() {
        InputStream in = null;
        URL operatorsURL = this.classLoader.getResource("META-INF/operators.xml");
        if (operatorsURL == null && (operatorsURL = this.classLoader.getResource("operators.xml")) != null) {
            LogService.getGlobal().log(String.valueOf(this.name) + ": putting operators.xml in root directory of jar is deprecated. Use META-INF directory instead!", 5);
        }
        if (operatorsURL != null) {
            try {
                in = operatorsURL.openStream();
            }
            catch (IOException e) {
                LogService.getGlobal().log("Cannot read operators.xml from '" + this.archive.getName() + "'!", 6);
            }
        } else {
            try {
                Class<?> pluginInitator = Class.forName("com.rapidminer.PluginInit", false, this.getClassLoader());
                Method registerOperatorMethod = pluginInitator.getMethod("getOperatorStream", ClassLoader.class);
                in = (InputStream)registerOperatorMethod.invoke(null, this.getClassLoader());
            }
            catch (ClassNotFoundException pluginInitator) {
            }
            catch (SecurityException pluginInitator) {
            }
            catch (NoSuchMethodException pluginInitator) {
            }
            catch (IllegalArgumentException pluginInitator) {
            }
            catch (IllegalAccessException pluginInitator) {
            }
            catch (InvocationTargetException pluginInitator) {
                // empty catch block
            }
        }
        if (in != null) {
            Iterator<Dependency> i = this.pluginDependencies.iterator();
            while (i.hasNext()) {
                String pluginName = i.next().getPluginName();
                Plugin other = Plugin.getPlugin(pluginName);
                this.mergeClassLoader(other);
            }
            OperatorService.registerOperators(this.archive.getName(), in, this.classLoader, true);
        }
        RendererService.init(String.valueOf(this.name) + "\\ioobjects.xml", this.classLoader.getResource("META-INF/ioobjects.xml"), (ClassLoader)this.classLoader);
    }

    public List<BuildingBlock> getBuildingBlocks() {
        LinkedList<BuildingBlock> result;
        block22: {
            PluginClassLoader independentLoader;
            URL bbDefinition;
            result = new LinkedList<BuildingBlock>();
            URL url = null;
            try {
                url = new URL("file", null, this.file.getAbsolutePath());
            }
            catch (MalformedURLException e1) {
                LogService.getGlobal().log("Cannot load plugin building blocks. Skipping...", 6);
            }
            if (url != null && (bbDefinition = (independentLoader = new PluginClassLoader(new URL[]{url})).getResource("com/rapidminer/resources/buildingblocks.txt")) != null) {
                BufferedReader in = null;
                try {
                    try {
                        in = new BufferedReader(new InputStreamReader(bbDefinition.openStream()));
                        String line = null;
                        while ((line = in.readLine()) != null) {
                            URL bbURL = this.classLoader.getResource("com/rapidminer/resources/" + line);
                            BufferedReader bbIn = null;
                            try {
                                try {
                                    bbIn = new BufferedReader(new InputStreamReader(bbURL.openStream()));
                                    result.add(new BuildingBlock(bbIn));
                                }
                                catch (IOException e) {
                                    LogService.getGlobal().log("Cannot load plugin building blocks. Skipping...", 6);
                                    if (bbIn == null) continue;
                                    bbIn.close();
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                if (bbIn != null) {
                                    bbIn.close();
                                }
                                throw throwable;
                            }
                            if (bbIn == null) continue;
                            bbIn.close();
                        }
                    }
                    catch (IOException e) {
                        LogService.getGlobal().log("Cannot load plugin building blocks.", 5);
                        if (in == null) break block22;
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            LogService.getGlobal().log("Cannot close stream to plugin building blocks.", 6);
                        }
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            LogService.getGlobal().log("Cannot close stream to plugin building blocks.", 6);
                        }
                    }
                }
            }
        }
        return result;
    }

    public AboutBox createAboutBox(Frame owner, Image productLogo) {
        String about = "";
        try {
            URL url = this.classLoader.getResource("META-INF/ABOUT.NFO");
            if (url != null) {
                about = Tools.readTextFile(new InputStreamReader(url.openStream()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new AboutBox(owner, this.name, this.version, "Vendor: " + (this.vendor != null ? this.vendor : "unknown"), "URL: " + (this.url != null ? this.url : "unknown"), about, productLogo);
    }

    public static void findPlugins(File pluginDir, boolean showWarningForNonPluginJars) {
        if (!pluginDir.exists() || !pluginDir.isDirectory()) {
            return;
        }
        File[] files = pluginDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        allPlugins = new LinkedList<Plugin>();
        int i = 0;
        while (i < files.length) {
            try {
                JarFile jarFile = new JarFile(files[i]);
                Manifest manifest = jarFile.getManifest();
                Attributes attributes = manifest.getMainAttributes();
                if (RAPIDMINER_TYPE_PLUGIN.equals(attributes.getValue(RAPIDMINER_TYPE))) {
                    allPlugins.add(new Plugin(files[i]));
                } else if (showWarningForNonPluginJars) {
                    LogService.getGlobal().logWarning("The jar file '" + jarFile.getName() + "' does not contain an entry '" + RAPIDMINER_TYPE + "' in its manifest and will therefore not be loaded (if this file actually is a plugin updating the plugin file might help).");
                }
            }
            catch (Throwable e) {
                LogService.getGlobal().log("Cannot load plugin '" + files[i] + "': " + e.getMessage(), 6);
            }
            ++i;
        }
    }

    protected void mergeClassLoader(Plugin other) {
        Plugin.mergeClassLoaders(other.classLoader, this.classLoader);
    }

    private static void mergeClassLoaders(PluginClassLoader first, PluginClassLoader second) {
        URL[] otherURLs = first.getURLs();
        int i = 0;
        while (i < otherURLs.length) {
            second.addDependingURL(otherURLs[i]);
            ++i;
        }
    }

    public String toString() {
        return String.valueOf(this.name) + " " + this.version + " (" + this.archive.getName() + ") depending on " + this.pluginDependencies;
    }

    public static void registerAllPlugins(File pluginDirectory, boolean showWarningForNonPluginJars) {
        File pluginDir = pluginDirectory;
        if (pluginDir == null) {
            pluginDir = ParameterService.getPluginDir();
        }
        Plugin.findPlugins(pluginDir, showWarningForNonPluginJars);
        Iterator<Plugin> i = allPlugins.iterator();
        while (i.hasNext()) {
            Plugin plugin = i.next();
            if (plugin.checkDependencies(allPlugins)) continue;
            LogService.getGlobal().log("Cannot register operators from '" + plugin.getName() + "': Dependencies not fulfilled! This plugin needs a RapidMiner version " + plugin.getNecessaryRapidMinerVersion() + " and the following plugins:" + Tools.getLineSeparator() + plugin.getPluginDependencies(), 6);
            i.remove();
        }
        if (allPlugins.size() > 0) {
            i = allPlugins.iterator();
            while (i.hasNext()) {
                i.next().register();
            }
        }
    }

    public static ClassLoader getMajorClassLoader() {
        return MAJOR_CLASS_LOADER;
    }

    public static List<Plugin> getAllPlugins() {
        return allPlugins;
    }

    public static Plugin getPlugin(String name) {
        for (Plugin plugin : allPlugins) {
            if (!plugin.getName().equals(name)) continue;
            return plugin;
        }
        return null;
    }

    public static void initPluginGuis(MainFrame mainframe) {
        Plugin.callPluginInitMethods("initGui", new Class[]{MainFrame.class}, new Object[]{mainframe}, false);
    }

    public static void initPlugins() {
        Plugin.callPluginInitMethods("initPlugin", new Class[0], new Object[0], true);
    }

    public static void initPluginUpdateManager() {
        Plugin.callPluginInitMethods("initPluginManager", new Class[0], new Object[0], false);
    }

    public static void initFinalChecks() {
        Plugin.callPluginInitMethods("initFinalChecks", new Class[0], new Object[0], false);
    }

    private static void callPluginInitMethods(String methodName, Class[] arguments, Object[] argumentValues, boolean useOriginalJarClassLoader) {
        List<Plugin> plugins = Plugin.getAllPlugins();
        for (Plugin plugin : plugins) {
            try {
                ClassLoader classLoader = plugin.getClassLoader();
                if (useOriginalJarClassLoader) {
                    classLoader = plugin.getOriginalClassLoader();
                }
                Class<?> pluginInitator = Class.forName("com.rapidminer.PluginInit", false, classLoader);
                Method initGuiMethod = pluginInitator.getMethod(methodName, arguments);
                initGuiMethod.invoke(null, argumentValues);
            }
            catch (ClassNotFoundException classLoader) {
            }
            catch (SecurityException classLoader) {
            }
            catch (NoSuchMethodException classLoader) {
            }
            catch (IllegalArgumentException classLoader) {
            }
            catch (IllegalAccessException classLoader) {
            }
            catch (InvocationTargetException e) {
                LogService.getGlobal().logWarning("PluginInit." + methodName + " of Plugin " + plugin.getName() + " causes an error: " + e.getTargetException().getMessage());
            }
        }
    }

    public static void initPluginSplashTexts() {
        Plugin.callPluginInitMethods("initSplashTexts", new Class[0], new Object[0], false);
    }

    public static void initAboutTexts(Properties properties) {
        Plugin.callPluginInitMethods("initAboutTexts", new Class[]{Properties.class}, new Object[]{properties}, false);
    }

    public boolean showAboutBox() {
        try {
            Class<?> pluginInitator = Class.forName("com.rapidminer.PluginInit", false, this.getOriginalClassLoader());
            Method initGuiMethod = pluginInitator.getMethod("showAboutBox", new Class[0]);
            Boolean showAboutBox = (Boolean)initGuiMethod.invoke(null, new Object[0]);
            return showAboutBox;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return true;
    }
}

