/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.Process;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.wizards.AbstractConfigurationWizard;
import com.rapidminer.gui.wizards.ConfigurationListener;
import com.rapidminer.operator.ClassNameMapper;
import com.rapidminer.operator.FileChooserTextField;
import com.rapidminer.operator.LabelRadioButton;
import com.rapidminer.operator.TextSourceTableModel;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.parameter.UndefinedParameterError;
import edu.udo.cs.wvtool.generic.inputfilter.WVTInputFilter;
import edu.udo.cs.wvtool.generic.loader.UniversalLoader;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class WVToolConfigurationWizard
extends AbstractConfigurationWizard {
    private static final long serialVersionUID = 2852889200016145801L;
    private final FileChooserTextField singleDirChooser = new FileChooserTextField((Component)((Object)this), true);
    private final LabelRadioButton singleDirSelector = new LabelRadioButton("Specify a single directory with text documents");
    private final LabelRadioButton classSelector = new LabelRadioButton("Specify a directory with text documents for each class");
    private final TextSourceTableModel tableModel = new TextSourceTableModel();
    private final FileChooserTextField fileChooser = new FileChooserTextField((Component)((Object)this), false);
    private final LabelRadioButton fileChooserSelector = new LabelRadioButton("Select a previously created word list");
    private final LabelRadioButton noWordListSelector = new LabelRadioButton("Create the word list automatically from the texts");
    private final String[] languages = new String[]{"english", "other/mixed", "german", "danish", "dutch", "finnish", "french", "italian", "norwegian", "portuguese", "russian", "spanish", "swedish"};
    private String selectedLanguage = this.languages[0];
    private final JComboBox languageBox = new JComboBox<String>(this.languages);
    private WVTDocumentInfo previewDocInfo = null;
    private final UniversalLoader loader = new UniversalLoader();
    private static final int PREVIEW_LINES = 100;
    private final String[] inputFilterClassNames = new String[]{"edu.udo.cs.wvtool.generic.inputfilter.TextInputFilter", "edu.udo.cs.wvtool.generic.inputfilter.XMLInputFilter"};
    private final JTextArea previewArea = new JTextArea(10, 20);
    private final JComboBox filterSelector = new JComboBox<String>(this.inputFilterClassNames);
    private final Process process;

    public WVToolConfigurationWizard(ConfigurationListener listener) {
        super("WVTool Configuration Wizard", listener);
        JPanel panel = new JPanel();
        this.process = listener.getProcess();
        panel.add(new JLabel("This Wizard will guide you through configuring the wvtool"));
        this.addSourceSelectionStep(listener.getParameters());
        this.addLanguageSelectionStep(listener.getParameters());
        this.addWordListSelectionStep(listener.getParameters());
    }

    protected void performStepAction(int currentStep, int oldStep) {
        this.previewDocInfo = null;
        if (currentStep > 0 && currentStep < 3) {
            try {
                File dir;
                File[] files;
                String dirName = null;
                if (this.singleDirSelector.getButton().isSelected()) {
                    dirName = this.singleDirChooser.getTextField().getText();
                } else if (this.tableModel.getRowCount() > 0) {
                    dirName = (String)this.tableModel.getValueAt(0, 1);
                }
                if (dirName != null && (files = (dir = new File(dirName)).listFiles(new FileFilter(){

                    public boolean accept(File arg0) {
                        return arg0.isFile();
                    }
                })) != null && files.length > 0) {
                    this.previewDocInfo = new WVTDocumentInfo(files[0].getCanonicalPath(), "", "", "");
                }
            }
            catch (Exception e) {
                this.previewDocInfo = null;
            }
            this.updatePreviewText();
        }
    }

    protected void finish(ConfigurationListener listener) {
        Parameters parameters = listener.getParameters();
        LinkedList<String[]> texts = new LinkedList<String[]>();
        if (this.singleDirSelector.getButton().isSelected()) {
            texts.add(new String[]{"texts", this.singleDirChooser.getTextField().getText()});
        } else {
            int i = 0;
            while (i < this.tableModel.getRowCount()) {
                texts.add(new String[]{(String)this.tableModel.getValueAt(i, 0), (String)this.tableModel.getValueAt(i, 1)});
                ++i;
            }
        }
        parameters.setParameter("texts", Parameters.transformList2String(texts));
        if (!this.selectedLanguage.equals("other/mixed")) {
            parameters.setParameter("default_content_language", this.selectedLanguage);
            parameters.setParameter("stemmer", "SnowballStemmerWrapper");
            if (this.selectedLanguage.equals("english")) {
                parameters.setParameter("stemmer", "LovinsStemmerWrapper");
                parameters.setParameter("wordfilter", "StopWordsWrapper");
            } else if (this.selectedLanguage.equals("french")) {
                parameters.setParameter("wordfilter", "StopwordsFrench");
            } else if (this.selectedLanguage.equals("german")) {
                parameters.setParameter("wordfilter", "StopWordsWrapperGerman");
            } else {
                parameters.setParameter("wordfilter", "DummyWordFilter");
            }
        } else {
            parameters.setParameter("default_content_language", "");
            parameters.setParameter("stemmer", "DummyStemmer");
            parameters.setParameter("wordfilter", "DummyWordFilter");
            parameters.setParameter("min_chars", "2");
        }
        if (!this.noWordListSelector.getButton().isSelected()) {
            parameters.setParameter("input_word_list", this.fileChooser.getTextField().getText());
        } else {
            parameters.setParameter("input_word_list", null);
        }
        ClassNameMapper inputFilterMapper = new ClassNameMapper(this.inputFilterClassNames);
        parameters.setParameter("inputfilter", inputFilterMapper.getShortClassNames()[this.filterSelector.getSelectedIndex()]);
        listener.setParameters(parameters);
        this.dispose();
        RapidMinerGUI.getMainFrame().getPropertyTable().refresh();
    }

    private void addSourceSelectionStep(Parameters parameters) {
        List textList;
        boolean singleDir = true;
        try {
            textList = Parameters.transformString2List((String)parameters.getParameter("texts"));
        }
        catch (UndefinedParameterError e) {
            textList = null;
        }
        if (textList != null && textList.size() > 0) {
            singleDir = false;
            for (Object entry : textList) {
                File file;
                Object[] pair = (Object[])entry;
                if (textList.size() == 1 && pair[0].equals("texts")) {
                    file = this.process.resolveFileName((String)pair[1]);
                    this.singleDirChooser.getTextField().setText(file.getAbsolutePath());
                    singleDir = true;
                    continue;
                }
                file = this.process.resolveFileName((String)pair[1]);
                this.tableModel.addRow((String)pair[0], file);
            }
        }
        final JPanel sourceSelectionPanel = new JPanel();
        sourceSelectionPanel.setLayout(new GridBagLayout());
        ButtonGroup selectorGroup = new ButtonGroup();
        selectorGroup.add(this.singleDirSelector.getButton());
        if (singleDir) {
            this.singleDirSelector.getButton().setSelected(true);
        } else {
            this.classSelector.getButton().setSelected(true);
        }
        selectorGroup.add(this.classSelector.getButton());
        final JTable classTable = new JTable(this.tableModel);
        classTable.setPreferredScrollableViewportSize(new Dimension(80, 150));
        JPanel classTablePanel = new JPanel(new BorderLayout());
        classTablePanel.add((Component)classTable, "Center");
        JPanel tableEditButtons = new JPanel(new FlowLayout(3));
        final JButton addClassButton = new JButton("Add...");
        addClassButton.setToolTipText("Add a single directory with text documents");
        addClassButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    File file;
                    FileChooserTextField dirField = new FileChooserTextField(sourceSelectionPanel, true);
                    JPanel classPanel = new JPanel(new GridBagLayout());
                    GridBagConstraints gbc = new GridBagConstraints();
                    gbc.gridy = 0;
                    gbc.gridx = -1;
                    gbc.gridwidth = 2;
                    gbc.gridheight = 1;
                    gbc.fill = 0;
                    gbc.anchor = 17;
                    classPanel.add((Component)new JLabel("Class name: "), gbc);
                    JTextField classField = new JTextField();
                    gbc.fill = 2;
                    gbc.weightx = 1.0;
                    classPanel.add((Component)classField, gbc);
                    JPanel dirPanel = new JPanel(new BorderLayout());
                    dirPanel.add((Component)new JLabel("Directory:      "), "West");
                    dirPanel.add((Component)dirField, "Center");
                    JPanel classAddingPane = new JPanel(new GridLayout(0, 1));
                    classAddingPane.add(classPanel);
                    classAddingPane.add(dirPanel);
                    int result = JOptionPane.showConfirmDialog(sourceSelectionPanel, classAddingPane, "Add a class", 2, -1);
                    if (result == 0 && (file = new File(dirField.getTextField().getText())).exists()) {
                        WVToolConfigurationWizard.this.tableModel.addRow(classField.getText(), file);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        final JButton delClassButton = new JButton("Remove");
        delClassButton.setToolTipText("Remove the selected directory");
        delClassButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                int rowIndex = classTable.getSelectedRow();
                if (rowIndex >= 0) {
                    WVToolConfigurationWizard.this.tableModel.delRow(rowIndex);
                }
            }
        });
        final JButton dirClassButton = new JButton("Add all subdirectories...");
        dirClassButton.setToolTipText("Automatically add all subdirectories of a directory");
        dirClassButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    FileChooserTextField dirField = new FileChooserTextField(sourceSelectionPanel, true);
                    JPanel dirPanel = new JPanel(new BorderLayout());
                    dirPanel.add((Component)new JLabel("Directory: "), "West");
                    dirPanel.add((Component)dirField, "Center");
                    int result = JOptionPane.showConfirmDialog(sourceSelectionPanel, dirPanel, "Add a directory", 2, -1);
                    if (result == 0) {
                        String dirStr = dirField.getTextField().getText();
                        File dir = new File(dirStr);
                        if (!dir.exists() || !dir.isDirectory()) {
                            JOptionPane.showMessageDialog(null, "The directory does not exist or is not accessible at the moment.");
                        } else {
                            int numFiles = 0;
                            int numDirectories = 0;
                            File[] files = dir.listFiles();
                            int i = 0;
                            while (i < files.length) {
                                if (files[i].isFile()) {
                                    ++numFiles;
                                } else {
                                    ++numDirectories;
                                    WVToolConfigurationWizard.this.tableModel.addRow(files[i].getName(), files[i]);
                                }
                                ++i;
                            }
                            if (numFiles > 0) {
                                JOptionPane.showMessageDialog(null, "This directory contains individual files. These will be ignored.");
                            }
                            if (numDirectories == 0) {
                                JOptionPane.showMessageDialog(null, "This directory does not contain any subdirectories");
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        tableEditButtons.add(addClassButton);
        tableEditButtons.add(delClassButton);
        tableEditButtons.add(dirClassButton);
        this.singleDirSelector.getButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                WVToolConfigurationWizard.this.singleDirChooser.setEnabled(true);
                classTable.setEnabled(false);
                addClassButton.setEnabled(false);
                delClassButton.setEnabled(false);
                dirClassButton.setEnabled(false);
            }
        });
        this.classSelector.getButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                WVToolConfigurationWizard.this.singleDirChooser.setEnabled(false);
                classTable.setEnabled(true);
                addClassButton.setEnabled(true);
                delClassButton.setEnabled(true);
                dirClassButton.setEnabled(true);
            }
        });
        if (singleDir) {
            classTable.setEnabled(false);
            addClassButton.setEnabled(false);
            delClassButton.setEnabled(false);
            dirClassButton.setEnabled(false);
        } else {
            this.singleDirChooser.setEnabled(false);
        }
        String sourceSelectionText = "Select the source from which the texts are loaded. ";
        sourceSelectionText = String.valueOf(sourceSelectionText) + "You can either load all texts from one directory. In this case no class information is provided. ";
        sourceSelectionText = String.valueOf(sourceSelectionText) + "Secondly, you can select a directory with texts for each class separately. ";
        sourceSelectionText = String.valueOf(sourceSelectionText) + "Finally, you can define a single directory containing a subdirectory with texts for each class.";
        JTextArea sourceSelectionTextArea = new JTextArea(10, 5);
        sourceSelectionTextArea.setText(sourceSelectionText);
        sourceSelectionTextArea.setBackground(sourceSelectionPanel.getBackground());
        sourceSelectionTextArea.setWrapStyleWord(true);
        sourceSelectionTextArea.setLineWrap(true);
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new FlowLayout(3));
        titlePanel.add(new JLabel("<html><h1>Step 1: Source Selection</h1></html>"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.anchor = 12;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(7, 7, 7, 7);
        GridBagConstraints gbcSeparator = (GridBagConstraints)gbc.clone();
        sourceSelectionPanel.add((Component)titlePanel, gbc);
        sourceSelectionPanel.add((Component)sourceSelectionTextArea, gbc);
        sourceSelectionPanel.add((Component)this.singleDirSelector, gbc);
        sourceSelectionPanel.add((Component)this.singleDirChooser, gbc);
        sourceSelectionPanel.add((Component)new JSeparator(), gbcSeparator);
        sourceSelectionPanel.add((Component)this.classSelector, gbc);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        sourceSelectionPanel.add((Component)new JScrollPane(classTable), gbc);
        gbc.fill = 2;
        gbc.weighty = 0.0;
        sourceSelectionPanel.add((Component)tableEditButtons, gbc);
        this.addStep(sourceSelectionPanel);
    }

    private void addWordListSelectionStep(Parameters parameters) {
        File wordListFile = null;
        try {
            wordListFile = this.process.resolveFileName(parameters.getParameter("input_word_list"));
        }
        catch (UndefinedParameterError e) {
            wordListFile = null;
        }
        if (wordListFile != null) {
            this.fileChooser.getTextField().setText(wordListFile.getAbsolutePath());
        }
        JPanel wordListSelectionPanel = new JPanel();
        wordListSelectionPanel.setLayout(new GridBagLayout());
        ButtonGroup selectorGroup = new ButtonGroup();
        selectorGroup.add(this.fileChooserSelector.getButton());
        selectorGroup.add(this.noWordListSelector.getButton());
        if (wordListFile == null) {
            this.noWordListSelector.getButton().setSelected(true);
        } else {
            this.fileChooserSelector.getButton().setSelected(true);
        }
        this.fileChooserSelector.getButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                WVToolConfigurationWizard.this.fileChooser.setEnabled(true);
            }
        });
        this.noWordListSelector.getButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                WVToolConfigurationWizard.this.fileChooser.setEnabled(false);
            }
        });
        if (wordListFile != null) {
            this.fileChooser.setEnabled(true);
        } else {
            this.fileChooser.setEnabled(false);
        }
        String wordListSelectionText = "If you already obtained a word list with document frequencies, you can use this word list for the selected texts.";
        wordListSelectionText = String.valueOf(wordListSelectionText) + "You should do this especially if you want to apply a previously learned model to a new set of texts.";
        JTextArea wordListSelectionTextArea = new JTextArea();
        wordListSelectionTextArea.setText(wordListSelectionText);
        wordListSelectionTextArea.setBackground(wordListSelectionPanel.getBackground());
        wordListSelectionTextArea.setWrapStyleWord(true);
        wordListSelectionTextArea.setLineWrap(true);
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new FlowLayout(3));
        titlePanel.add(new JLabel("<html><h1>Step 4: Word List Selection</h1></html>"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(7, 7, 7, 7);
        wordListSelectionPanel.add((Component)titlePanel, gbc);
        wordListSelectionPanel.add((Component)wordListSelectionTextArea, gbc);
        wordListSelectionPanel.add((Component)this.noWordListSelector, gbc);
        wordListSelectionPanel.add((Component)new JSeparator(), gbc);
        wordListSelectionPanel.add((Component)this.fileChooserSelector, gbc);
        wordListSelectionPanel.add((Component)this.fileChooser, gbc);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        JTextArea pseudoTextArea = new JTextArea();
        pseudoTextArea.setBackground(wordListSelectionPanel.getBackground());
        wordListSelectionPanel.add((Component)pseudoTextArea, gbc);
        this.addStep(wordListSelectionPanel);
    }

    private void addLanguageSelectionStep(Parameters parameters) {
        String languageStr;
        try {
            languageStr = parameters.getParameter("default_content_language");
        }
        catch (UndefinedParameterError e) {
            languageStr = null;
        }
        if (languageStr != null) {
            int index = -1;
            int i = 0;
            while (i < this.languages.length && index < 0) {
                if (this.languages[i].equalsIgnoreCase(languageStr)) {
                    index = i;
                }
                ++i;
            }
            if (index >= 0) {
                this.languageBox.setSelectedIndex(index);
                this.selectedLanguage = this.languages[index];
            }
        }
        JPanel languageSelectionPanel = new JPanel();
        languageSelectionPanel.setLayout(new GridBagLayout());
        this.languageBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent arg0) {
                WVToolConfigurationWizard.this.selectedLanguage = (String)WVToolConfigurationWizard.this.languageBox.getSelectedItem();
            }
        });
        String languageSelectionText = "Please select the language the text documents are written in.";
        JTextArea languageSelectionTextArea = new JTextArea(10, 5);
        languageSelectionTextArea.setText(languageSelectionText);
        languageSelectionTextArea.setBackground(languageSelectionPanel.getBackground());
        languageSelectionTextArea.setWrapStyleWord(true);
        languageSelectionTextArea.setLineWrap(true);
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new FlowLayout(3));
        titlePanel.add(new JLabel("<html><h1>Step 3: Language Selection</h1><html>"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(7, 7, 7, 7);
        languageSelectionPanel.add((Component)titlePanel, gbc);
        languageSelectionPanel.add((Component)languageSelectionTextArea, gbc);
        languageSelectionPanel.add((Component)this.languageBox, gbc);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        JTextArea pseudoTextArea = new JTextArea();
        pseudoTextArea.setBackground(languageSelectionPanel.getBackground());
        languageSelectionPanel.add((Component)pseudoTextArea, gbc);
        this.addStep(languageSelectionPanel);
    }

    public void updatePreviewText() {
        if (this.previewDocInfo != null) {
            try {
                String className = (String)this.filterSelector.getSelectedItem();
                WVTInputFilter filter = null;
                filter = (WVTInputFilter)Class.forName(className).newInstance();
                if (filter != null) {
                    BufferedReader in = new BufferedReader(filter.convertToPlainText(this.loader.loadDocument(this.previewDocInfo), this.previewDocInfo));
                    String buf = null;
                    int counter = 0;
                    StringBuffer previewText = new StringBuffer();
                    while ((buf = in.readLine()) != null && counter < 100) {
                        previewText.append(buf);
                        previewText.append("\n");
                        ++counter;
                    }
                    in.close();
                    this.previewArea.setText(previewText.toString());
                    this.previewArea.setCaretPosition(0);
                }
            }
            catch (Exception e) {
                this.previewArea.setText("No preview available");
            }
        } else {
            this.previewArea.setText("No preview available");
        }
    }
}

