/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.matrix;

import com.rapidminer.tools.IterationArrayList;
import com.rapidminer.tools.math.matrix.Matrix;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixComboBoxVisualizer<Ex, Ey>
extends JPanel
implements ItemListener {
    private static final long serialVersionUID = 1890397148444056696L;
    private List<Ex> xLabels;
    private List<Ey> yLabels;
    private JComboBox chooseBox1;
    private JComboBox chooseBox2;
    private JLabel label;
    private Matrix<Ex, Ey> matrix;

    public MatrixComboBoxVisualizer(Matrix<Ex, Ey> matrix) {
        this.matrix = matrix;
        this.xLabels = new IterationArrayList(matrix.getXLabels());
        this.yLabels = new IterationArrayList(matrix.getYLabels());
        JPanel panel = new JPanel(new FlowLayout());
        this.chooseBox1 = new JComboBox<Ex>(new Vector<Ex>(this.xLabels));
        this.chooseBox2 = new JComboBox<Ey>(new Vector<Ey>(this.yLabels));
        this.label = new JLabel("value: 0.0");
        this.chooseBox1.addItemListener(this);
        this.chooseBox2.addItemListener(this);
        panel.add(new JLabel("x: "));
        panel.add(this.chooseBox1);
        panel.add(new JLabel(" y: "));
        panel.add(this.chooseBox2);
        panel.add(this.label);
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Ex o1 = this.xLabels.get(this.chooseBox1.getSelectedIndex());
        Ey o2 = this.yLabels.get(this.chooseBox2.getSelectedIndex());
        this.label.setText("value: " + this.matrix.getEntry(o1, o2));
    }
}

